% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionDecorator_CoreStatistics.R
\name{kurtosis}
\alias{kurtosis}
\title{Distribution Kurtosis}
\usage{
kurtosis(object, excess = TRUE)
}
\arguments{
\item{object}{Distribution.}

\item{excess}{logical, if TRUE (default) excess Kurtosis returned}
}
\value{
Kurtosis as a numeric.
}
\description{
Kurtosis of a distribution
}
\details{
The kurtosis of a distribution is defined by the fourth standardised moment of the
distribution,
\deqn{k_X = E_X[\frac{x - \mu}{\sigma}^4]}{k_X = E_X[((x - \mu)/\sigma)^4]}
where \eqn{E_X} is the expectation of distribution X, \eqn{\mu} is the mean of the distribution and \eqn{\sigma} is the
standard deviation of the distribution. Excess Kurtosis is Kurtosis - 3.

If an analytic expression isn't available, returns error. To impute a numerical expression, use the
\code{\link{CoreStatistics}} decorator.
}
\section{R6 Usage}{
 $kurtosis(excess = TRUE)
}

\seealso{
\code{\link{CoreStatistics}} and \code{\link{decorate}}
}
