% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{Gamma}
\alias{Gamma}
\title{Create a Gamma distribution}
\usage{
Gamma(shape, rate = 1)
}
\arguments{
\item{shape}{The shape parameter. Can be any positive number.}

\item{rate}{The rate parameter. Can be any positive number. Defaults
to \code{1}.}
}
\value{
A \code{Gamma} object.
}
\description{
Several important distributions are special cases of the Gamma
distribution. When the shape parameter is \code{1}, the Gamma is an
exponential distribution with parameter \eqn{1/\beta}. When the
\eqn{shape = n/2} and \eqn{rate = 1/2}, the Gamma is a equivalent to
a chi squared distribution with n degrees of freedom. Moreover, if
we have \eqn{X_1} is \eqn{Gamma(\alpha_1, \beta)} and
\eqn{X_2} is \eqn{Gamma(\alpha_2, \beta)}, a function of these two variables
of the form \eqn{\frac{X_1}{X_1 + X_2}} \eqn{Beta(\alpha_1, \alpha_2)}.
This last property frequently appears in another distributions, and it
has extensively been used in multivariate methods. More about the Gamma
distribution will be added soon.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3}, where the math
will render with additional detail.

In the following, let \eqn{X} be a Gamma random variable
with parameters
\code{shape} = \eqn{\alpha} and
\code{rate} = \eqn{\beta}.

\strong{Support}: \eqn{x \in (0, \infty)}

\strong{Mean}: \eqn{\frac{\alpha}{\beta}}

\strong{Variance}: \eqn{\frac{\alpha}{\beta^2}}

\strong{Probability density function (p.m.f)}:

\deqn{
    f(x) = \frac{\beta^{\alpha}}{\Gamma(\alpha)} x^{\alpha - 1} e^{-\beta x}
  }{
    f(x) = \frac{\beta^{\alpha}}{\Gamma(\alpha)} x^{\alpha - 1} e^{-\beta x}
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    f(x) = \frac{\Gamma(\alpha, \beta x)}{\Gamma{\alpha}}
  }{
    f(x) = \frac{\Gamma(\alpha, \beta x)}{\Gamma{\alpha}}
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \Big(\frac{\beta}{ \beta - t}\Big)^{\alpha}, \thinspace t < \beta
  }{
    E(e^(tX)) = \Big(\frac{\beta}{ \beta - t}\Big)^{\alpha}, \thinspace t < \beta
  }
}
\examples{

set.seed(27)

X <- Gamma(5, 2)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
\seealso{
Other continuous distributions: \code{\link{Beta}},
  \code{\link{Cauchy}}, \code{\link{ChiSquare}},
  \code{\link{Exponential}}, \code{\link{FisherF}},
  \code{\link{LogNormal}}, \code{\link{Logistic}},
  \code{\link{Normal}}, \code{\link{StudentsT}},
  \code{\link{Tukey}}, \code{\link{Uniform}},
  \code{\link{Weibull}}
}
\concept{continuous distributions}
