% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Geometric.R
\name{Geometric}
\alias{Geometric}
\title{Create a Geometric distribution}
\usage{
Geometric(p = 0.5)
}
\arguments{
\item{p}{The success probability for the distribution. \code{p} can be
any value in \verb{[0, 1]}, and defaults to \code{0.5}.}
}
\value{
A \code{Geometric} object.
}
\description{
The Geometric distribution can be thought of as a generalization
of the \code{\link[=Bernoulli]{Bernoulli()}} distribution where we ask: "if I keep flipping a
coin with probability \code{p} of heads, what is the probability I need
\eqn{k} flips before I get my first heads?" The Geometric
distribution is a special case of Negative Binomial distribution.
}
\details{
We recommend reading this documentation on
\url{https://alexpghayes.github.io/distributions3/}, where the math
will render with additional detail and much greater clarity.

In the following, let \eqn{X} be a Geometric random variable with
success probability \code{p} = \eqn{p}. Note that there are multiple
parameterizations of the Geometric distribution.

\strong{Support}: 0 < p < 1, \eqn{x = 0, 1, \dots}

\strong{Mean}: \eqn{\frac{1-p}{p}}

\strong{Variance}: \eqn{\frac{1-p}{p^2}}

\strong{Probability mass function (p.m.f)}:

\deqn{
    P(X = x) = p(1-p)^x,
   }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    P(X \le x) = 1 - (1-p)^{x+1}
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \frac{pe^t}{1 - (1-p)e^t}
  }{
    E(e^{tX}) = \frac{pe^t}{1 - (1-p)e^t}
  }
}
\examples{

set.seed(27)

X <- Geometric(0.3)
X

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)
}
\seealso{
Other discrete distributions: 
\code{\link{Bernoulli}()},
\code{\link{Binomial}()},
\code{\link{Categorical}()},
\code{\link{HurdleNegativeBinomial}()},
\code{\link{HurdlePoisson}()},
\code{\link{HyperGeometric}()},
\code{\link{Multinomial}()},
\code{\link{NegativeBinomial}()},
\code{\link{Poisson}()},
\code{\link{ZINegativeBinomial}()},
\code{\link{ZIPoisson}()},
\code{\link{ZTNegativeBinomial}()},
\code{\link{ZTPoisson}()}
}
\concept{discrete distributions}
