% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_parse_paygap.R
\name{div_parse_paygap}
\alias{div_parse_paygap}
\title{Prepare the paygap matrix to be published in LaTeX}
\usage{
div_parse_paygap(
  pg,
  label = NULL,
  min_nbr_show = NULL,
  max_length_jobID = 12,
  max_length_colnames = 9
)
}
\arguments{
\item{pg}{paygap object as created by div::div_paygap(). This is an S3 object with a specific structure}

\item{label}{character, the label to be used in the caption of the kable object}

\item{min_nbr_show}{numeric, if provided then only groups that have more than min_nbr_show employees in both categories (selectedValue and others) will be shown}

\item{max_length_jobID}{numeric, if provided the maximal length of the column jobID (in characters)}

\item{max_length_colnames}{numeric, if provided the maximal length of the column names (in characters)}
}
\value{
knitr::kable object (for LaTeX)
}
\description{
This function formats the paygap matrix (created by div_paygap()) and prepares it for printing via the function knitr::kable()
}
\examples{
d  <- div_fake_team()
pg <- div_paygap(d)
div_parse_paygap(pg)

}
\keyword{parse}
\keyword{paygap}
