% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{indices}
\alias{indices}
\title{Scalar indices of diversity}
\usage{
indices(x, samp = NULL, method = NULL)
}
\arguments{
\item{x}{either a \code{character} vector of occurrences or a table of counts (\code{matrix}).}

\item{samp}{(\code{vector}): Only applicable if \code{x} is vector of occurrence entries. The id of the sampling units. A necessary variable for SCOR.}

\item{method}{(\code{character}): The type of metric that is to be calculated. The default value (\code{NULL}) will calculate all implemented metrics.}
}
\description{
This function includes some indices that characterize a species-abundance/occurrence distribution.
}
\details{
This set is not complete and does not intend to supercede additional R packages (e.g. vegan). However, some metrics are presented here as they are not
implemented elsewhere or because they are invoked more frequently. The following entries can be added to the \code{method} argument of the function, which are
also named accordingly in the output table/vector.

\code{"richness"}: The number of sampled species.

\code{"shannon"}: The Shannon entropy.

\code{dom}: The Berger-Parker dominance index, the proportion of occurrences in the time bin that belong to the most frequent taxon.

\code{"hill2"}: The second order Hill number (Jost, 2006; q=2), which will be calculated by default. You can specify additional Hill numbers with adding \code{"hillXX"} to the \code{method}
argument, such as \code{"hill3"} for (q=3). The first Hill number is defined as the exponentiad version of Shannon entropy (Eq. 3 in Jost, 2006).

\code{"squares"}: The 'squares' richness estimator of J. Alroy (2018).

\code{"chao2"}: The Chao2 estimator for incidence-based data.

\code{"SCOR"}: The Sum Common Species Occurrence rate of Hannisdal et al. (2012). This method will only be calculated if the occurrence entries (vector)
 a collection vector is provided (see examples).
}
\section{References}{

Alroy, J. 2018. Limits to species richness in terrestrial communities. Ecology Letters.

Hannisdal, B., Henderiks, J., & Liow, L. H. (2012). Long-term evolutionary and ecological responses of calcifying phytoplankton to changes in atmospheric CO2. Global Change Biology, 18(12), 3504–3516. https://doi.org/10.1111/gcb.12007

Jost, L. (2006). Entropy and diversity. Oikos, 113, 363–375. https://doi.org/10.1111/j.2006.0030-1299.14714.x
}

\examples{
# the coral data
  data(corals)

# Pleistocene subset
  plei <- corals[corals$stg==94,]

# calculate everything
  pleiIndex<-indices(plei$genus, plei$coll)


}
