% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_distribution.R
\name{species_distribution}
\alias{species_distribution}
\alias{as_species_distribution}
\alias{as_species_distribution.numeric}
\alias{as_species_distribution.matrix}
\alias{as_species_distribution.data.frame}
\alias{as_species_distribution.wmppp}
\alias{as_species_distribution.character}
\alias{as_species_distribution.factor}
\alias{is_species_distribution}
\alias{as_probabilities}
\alias{as_probabilities.numeric}
\alias{as_probabilities.matrix}
\alias{as_probabilities.data.frame}
\alias{as_probabilities.wmppp}
\alias{as_probabilities.character}
\alias{as_probabilities.factor}
\alias{is_probabilities}
\alias{abundances}
\alias{as_abundances}
\alias{as_abundances.numeric}
\alias{as_abundances.matrix}
\alias{as_abundances.data.frame}
\alias{as_abundances.wmppp}
\alias{as_abundances.character}
\alias{as_abundances.factor}
\alias{is_abundances}
\alias{as.matrix.species_distribution}
\alias{as.double.species_distribution}
\alias{as.numeric.species_distribution}
\title{Species Distributions}
\usage{
species_distribution(x, names = NULL, weights = NULL, check_arguments = TRUE)

as_species_distribution(x, ...)

\method{as_species_distribution}{numeric}(x, ..., check_arguments = TRUE)

\method{as_species_distribution}{matrix}(
  x,
  names = NULL,
  weights = NULL,
  ...,
  check_arguments = TRUE
)

\method{as_species_distribution}{data.frame}(x, ..., check_arguments = TRUE)

\method{as_species_distribution}{wmppp}(x, ..., check_arguments = TRUE)

\method{as_species_distribution}{character}(x, ..., check_arguments = TRUE)

\method{as_species_distribution}{factor}(x, ..., check_arguments = TRUE)

is_species_distribution(x)

as_probabilities(x, ...)

\method{as_probabilities}{numeric}(x, ..., check_arguments = TRUE)

\method{as_probabilities}{matrix}(x, names = NULL, weights = NULL, ..., check_arguments = TRUE)

\method{as_probabilities}{data.frame}(x, ..., check_arguments = TRUE)

\method{as_probabilities}{wmppp}(x, ..., check_arguments = TRUE)

\method{as_probabilities}{character}(x, ..., check_arguments = TRUE)

\method{as_probabilities}{factor}(x, ..., check_arguments = TRUE)

is_probabilities(x)

abundances(
  x,
  round = TRUE,
  names = NULL,
  weights = NULL,
  check_arguments = TRUE
)

as_abundances(x, ...)

\method{as_abundances}{numeric}(x, round = TRUE, ..., check_arguments = TRUE)

\method{as_abundances}{matrix}(
  x,
  round = TRUE,
  names = NULL,
  weights = NULL,
  ...,
  check_arguments = TRUE
)

\method{as_abundances}{data.frame}(x, ..., check_arguments = TRUE)

\method{as_abundances}{wmppp}(x, ..., check_arguments = TRUE)

\method{as_abundances}{character}(x, ..., check_arguments = TRUE)

\method{as_abundances}{factor}(x, ..., check_arguments = TRUE)

is_abundances(x)

\method{as.matrix}{species_distribution}(x, use.names = TRUE, ...)

\method{as.double}{species_distribution}(x, use.names = TRUE, ...)

\method{as.numeric}{species_distribution}(x, use.names = TRUE, ...)
}
\arguments{
\item{x}{an object.}

\item{names}{The names of the species distributions.}

\item{weights}{the weights of the sites of the species distributions.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{...}{Unused.}

\item{round}{If \code{TRUE}, the values of \code{x} are rounded to the nearest integer.}

\item{use.names}{If \code{TRUE}, the names of the \code{species_distribution} are kept
in the matrix or vector they are converted to.}
}
\value{
An object of classes \code{species_distribution} and \code{abundances}
or \code{probabilities}.

\code{as.double()} and its synonymous \code{as.numeric()} return a numeric vector
that contains species abundances or probabilities of a single-row
\code{species_distribution}.
\code{as.matrix()} returns a numeric matrix if the \code{species_distribution} contains
several rows.
These are methods of the generic functions for class \code{species_distribution}.
}
\description{
A Species Distribution is a \link[tibble:tibble]{tibble::tibble} containing species abundances
or probabilities.
Rows of the tibble are communities and column are species.
Values are either abundances or probabilities.
Special columns contain the site names, and their weights
(e.g. their area or number of individuals):
their names must be "site" and "weight".
All other column names are considered as species names.
}
\details{
\code{species_distribution} objects include \code{abundances} and \code{probabilities}
objects.

\code{species_distribution()} creates a \code{species_distribution} object from a vector
or a matrix or a dataframe.

\code{as_species_distribution()}, \code{as_abundances()} and \code{as_probabilities} format
the numeric, matrix or dataframe \code{x} so that appropriate
versions of community functions (generic methods such as \link{plot} or
\link{div_richness}) are applied.
Abundance values are rounded (by default) to the nearest integer.
They also accept a \link[dbmss:wmppp]{dbmss::wmppp} objects,
i.e. a weighted, marked planar point pattern and count the abundances of
point types, character and factor objects.

\code{as_probabilities()} normalizes the vector \code{x} so that it sums to 1. It gives
the same output as \code{probabilities()} with \code{estimator = "naive"}.

\code{species_distribution} objects objects can be plotted by \link{plot} and \link{autoplot}.
}
\examples{
# Paracou data is a tibble
paracou_6_abd
# Class
class(paracou_6_abd)
is_species_distribution(paracou_6_abd)
# Whittaker plot fitted by a log-normal distribution
autoplot(paracou_6_abd[1,], fit_rac = TRUE, distribution = "lnorm")
# Character vectors
as_abundances(c("A", "C", "B", "C"))

}
