% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_eco_variables.R
\name{rangeSize}
\alias{rangeSize}
\title{Calculate common metrics of spatial distribution}
\usage{
rangeSize(coords, crs = "epsg:4326")
}
\arguments{
\item{coords}{2-column \code{data.frame} or \code{matrix} containing
x- and y-coordinates, respectively (e.g. longitude and latitude).}

\item{crs}{Coordinate reference system as a GDAL text string, EPSG code,
or object of class \code{crs}. Default is latitude-longitude (\code{EPSG:4326}).}
}
\value{
A 1-row, 7-column \code{matrix}
}
\description{
Calculate occurrence count, centroid coordinates, latitudinal range
(degrees), great circle distance (km), mean pairwise distance (km), and
summed minimum spanning tree length (km) for spatial point coordinates.
}
\details{
Coordinates and their distances are computed with respect to the original
coordinate reference system if supplied, except in calculation of latitudinal
range, for which projected coordinates are transformed to geodetic ones.
If \code{crs} is unspecified, by default points are assumed to be given in
latitude-longitude and distances are calculated with spherical geometry.

Duplicate coordinates will be removed. If a single unique point is supplied,
all distance measures returned will be \code{NA}.
}
\examples{
# generate 20 occurrences for a pseudo-species
# centred on Yellowstone National Park (latitude-longitude)
# normally distributed with a standard deviation ~110 km
set.seed(2)
x <- rnorm(20, 110.5885, 2)
y <- rnorm(20,  44.4280, 1)
pts <- cbind(x,y)

rangeSize(pts)

}
