% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.R
\name{imputate_outlier}
\alias{imputate_outlier}
\title{Imputate Outliers}
\usage{
imputate_outlier(.data, xvar, method)
}
\arguments{
\item{.data}{a data.frame or a \code{\link{tbl_df}}.}

\item{xvar}{variable name to replace missing value.}

\item{method}{method of missing values imputation.}
}
\value{
An object of imputation class.
Attributes of imputation class is as follows.
\itemize{
\item method : method of missing value imputation.
\itemize{
  \item predictor is numerical variable
  \itemize{
    \item "mean" : arithmetic mean
    \item "median" : median
    \item "mode" : mode
    \item "capping" : Imputate the upper outliers with 95 percentile,
    and Imputate the bottom outliers with 5 percentile.
  }
}
\item outlier_pos : position of outliers in predictor.
\item outliers : outliers. outliers corresponding to outlier_pos.
\item type : "outliers". type of imputation.
}
}
\description{
Outliers are imputated with some representative values and
statistical methods.
}
\details{
imputate_outlier() creates an imputation class.
The `imputation` class includes missing value position, imputated value,
and method of missing value imputation, etc.
The `imputation` class compares the imputated value with the original value
to help determine whether the imputated value is used in the analysis.

See vignette("transformation") for an introduction to these concepts.
}
\examples{
# Generate data for the example
carseats <- ISLR::Carseats
carseats[sample(seq(NROW(carseats)), 20), "Income"] <- NA
carseats[sample(seq(NROW(carseats)), 5), "Urban"] <- NA

# Replace the missing value of the Price variable with median
imputate_outlier(carseats, Price, method = "median")

# Replace the missing value of the Price variable with rpart
# The target variable is US.
imputate_outlier(carseats, Price, method = "capping")

## using dplyr -------------------------------------
library(dplyr)

# The mean before and after the imputation of the Price variable
carseats \%>\%
  mutate(Price_imp = imputate_outlier(carseats, Price, method = "capping")) \%>\%
  group_by(US) \%>\%
  summarise(orig = mean(Price, na.rm = TRUE),
    imputation = mean(Price_imp, na.rm = TRUE))

# If the variable of interest is a numarical variable
price <- imputate_outlier(carseats, Price)
price
summary(price)
plot(price)
}
\seealso{
\code{\link{imputate_na}}.
}
