% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasEquiv_EffectSize_Base.R
\name{delta_var}
\alias{delta_var}
\title{Expected bias to total score variance}
\usage{
delta_var(LambdaR, LambdaF, VarF, categorical = FALSE)
}
\arguments{
\item{LambdaR}{is the vector of factor loadings for the
reference group.}

\item{LambdaF}{is the vector of factor loadings for the
focal group.}

\item{VarF}{is the factor variance of the focal group.}

\item{categorical}{is a Boolean variable declaring whether the variables
in the model are ordered categorical. Categorical indicators are not supported
for this function.}
}
\value{
The expected bias in total score variance due to
measurement nonequivalence in equation 7, 8, and 9 of Nye & Drasgow (2011).
}
\description{
\code{delta_var} computes the expected bias in total score variance due
to measurement nonequivalence. \code{delta_var} will only work for
unidimensional linear models (not categorical).
}
\details{
\code{delta_var} is called by \code{dmacs_summary_single}, which
in turn is called by \code{\link{lavaan_dmacs}} and
\code{\link{mplus_dmacs}}, which are the only functions in this
package intended for casual users
}
\section{References}{

Nye, C. & Drasgow, F. (2011). Effect size indices for analyses of
measurement equivalence: Understanding the practical importance of
differences between groups. \emph{Journal of Applied Psychology, 96}(5),
966-980.
}

\examples{
LambdaF <- c(1.00, 0.74,  1.14, 0.92)
LambdaR <- c(1.00, 0.76,  1.31, 0.98)
VarF    <- 1.76
delta_var(LambdaR, LambdaF, VarF)

}
