% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{dmbc_fit_to_mcmc}
\alias{dmbc_fit_to_mcmc}
\title{Conversion of an \code{dmbc_fit} object to an object of class \code{mcmc}.}
\usage{
dmbc_fit_to_mcmc(res, include.burnin = FALSE, verbose = TRUE)
}
\arguments{
\item{res}{An object of type \code{dmbc_fit}.}

\item{include.burnin}{A logical scalar. If \code{TRUE} the burnin
iterations (if available) are not removed.}

\item{verbose}{A logical scalar. If \code{TRUE} prints additional
warnings during the conversion.}
}
\value{
An object of type \code{mcmc}.
}
\description{
\code{dmbc_fit_to_mcmc} converts an object of class \code{dmbc_fit}
  to an object with class \code{mcmc}.
}
\examples{
\donttest{
data(simdiss, package = "dmbc")

G <- 3
p <- 2
prm.prop <- list(z = 1.5, alpha = .75)
burnin <- 2000
nsim <- 1000
seed <- 2301

set.seed(seed)

control <- list(burnin = burnin, nsim = nsim, z.prop = prm.prop[["z"]],
  alpha.prop = prm.prop[["alpha"]], verbose = TRUE)
sim.dmbc <- dmbc(simdiss, p, G, control)
sim.mcmc <- dmbc_fit_to_mcmc(sim.dmbc@results[[1]], TRUE)
plot(sim.mcmc)
}
}
\seealso{
\code{\link{dmbc}()} for for fitting a DMBC model;
  \code{\link{dmbc_fit-class}};
  \code{\link[coda]{mcmc}}.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
