% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{dmbc_get_map}
\alias{dmbc_get_map}
\title{Extractor function for a fitted DMBC model.}
\usage{
dmbc_get_map(res, chain = 1)
}
\arguments{
\item{res}{An object of class \code{dmbc_fit_list}.}

\item{chain}{A length-one numeric vector indicating the MCMC chain number
to use.}
}
\value{
A named \code{list} with the following elements:
  \describe{
    \item{\code{z}: }{array of latent coordinates posterior mean estimates}
    \item{\code{alpha}: }{numeric vector of alpha posterior mean estimates}
    \item{\code{eta}: }{numeric vector of eta posterior mean estimates}
    \item{\code{sigma2}: }{numeric vector of sigma2 posterior mean estimates}
    \item{\code{lambda}: }{numeric vector of lambda posterior mean estimates}
    \item{\code{prob}: }{numeric matrix of probability posterior mean estimates}
    \item{\code{cluster}: }{numeric vector of cluster membership posterior
      mean estimates}
    \item{\code{logpost}: }{length-one numeric vector of the maximum
      log-posterior value}
    \item{\code{chain}: }{length-one numeric vector of the MCMC chain number
      used}
  }
}
\description{
\code{dmbc_get_map()} is an extractor function for extracting the
  maximum-a-posterior estimates of the parameters for a fitted DMBC model.
}
\examples{
\donttest{
data(simdiss, package = "dmbc")

G <- 3
p <- 2
prm.prop <- list(z = 1.5, alpha = .75)
burnin <- 2000
nsim <- 1000
seed <- 2301

set.seed(seed)

control <- list(burnin = burnin, nsim = nsim, z.prop = prm.prop[["z"]],
  alpha.prop = prm.prop[["alpha"]], random.start = TRUE, verbose = TRUE,
  nchains = 2, thin = 10, store.burnin = TRUE, threads = 2,
  parallel = "snow")
sim.dmbc <- dmbc(simdiss, p, G, control)

dmbc_get_map(sim.dmbc, chain = 1)
}
}
\references{
Venturini, S., Piccarreta, R. (2019), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Technical report.
}
\seealso{
\code{\link{dmbc_data}} for a description of the data format.

\code{\link{dmbc_fit_list}} for a description of the elements
  included in the returned object.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
