% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_example.R
\name{make_example}
\alias{make_example}
\title{Create examples in working directory}
\usage{
make_example(name)
}
\arguments{
\item{name}{name of the example}
}
\value{
invisibly \code{NULL}
}
\description{
Each package based on a \code{dmdScheme} can contain examples. This function is the interface to these examples.
In the package \code{dmdScheme}, no examples are included.
The function has two basic usages:
\enumerate{
\item by using \code{make_example(schemeName = "NameOfTheScheme")} all included
examples are listed
\item by using \code{make_example(name = "basic", schemeName = "NameOfTheScheme")} it will create the example named \code{basic} in a
subdirectory in the current working directory. An existing directory with
the same name, will nod be overwritten!
}
}
\details{
The examples have to be located in a directory called \code{example_data}.
The function is doing two things:
\enumerate{
\item Copying the \strong{complete} directory from the \code{example_data} directory
to the current working directory
\item running \code{knitr::purl} on \strong{all} \verb{./code/*.Rmd} to extract the code into \code{.R}
script files. If you want to include an RMarkdown files in the \code{./code}
directory from thisa, use the \code{.rmd} extension (small letters).
}
}
\examples{
make_example()
\dontrun{
make_example("basic")
}
}
