% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_dmdScheme.R,
%   R/as_dmdScheme.dmdSchemeData_raw.R, R/as_dmdScheme.dmdSchemeSet_raw.R,
%   R/as_dmdScheme.xml_document.R
\name{as_dmdScheme}
\alias{as_dmdScheme}
\alias{as_dmdScheme.dmdSchemeData_raw}
\alias{as_dmdScheme.dmdSchemeSet_raw}
\alias{as_dmdScheme.xml_document}
\title{Generic function to convert the data stored in the object \code{x} into a new object of class \code{dmdScheme...}}
\usage{
as_dmdScheme(x, keepData = FALSE, ..., verbose = FALSE)

\method{as_dmdScheme}{dmdSchemeData_raw}(
  x,
  keepData = TRUE,
  convertTypes = TRUE,
  warnToError = TRUE,
  checkVersion = TRUE,
  ...,
  verbose = FALSE
)

\method{as_dmdScheme}{dmdSchemeSet_raw}(
  x,
  keepData = FALSE,
  warnToError = TRUE,
  convertTypes = TRUE,
  checkVersion = TRUE,
  ...,
  verbose = FALSE
)

\method{as_dmdScheme}{xml_document}(x, keepData = TRUE, useSchemeInXml = NULL, ..., verbose = FALSE)
}
\arguments{
\item{x}{object to be converted}

\item{keepData}{if the data should be kept or replaced with one row with NAs}

\item{...}{additional arguments for methods}

\item{verbose}{give verbose progress info. Useful for debugging.}

\item{convertTypes}{if \code{TRUE}, the types specified in the types column
are used for the data type. Otherwise, they are left at type
\code{character}}

\item{warnToError}{if \code{TRUE}, warnings generated during the conversion
will raise an error}

\item{checkVersion}{if \code{TRUE}, a version mismatch between the package
and the data \code{x} will result in an error. If \code{FALSE}, the check
will be skipped.}

\item{useSchemeInXml}{if \code{TRUE}, use scheme definition in xml and raise
an error if the xml does not contain a scheme definition. If False, use the
scheme definition from the corresponding installed package, even if the xml
contains a scheme definition. if \code{NULL} (the default), use the
definition in the xml if it contains a definition, if not use the
corresponding definition from the installed package.}
}
\value{
dmdScheme as object of class \code{dmdScheme_set}
}
\description{
Generic function to convert the data stored in the object \code{x} into a new object of class \code{dmdScheme...}
}
\examples{
as_dmdScheme(dmdScheme_raw(), keepData = TRUE)
as_dmdScheme(dmdScheme_raw()$Experiment)

xml <- as_xml(dmdScheme_example())
x <- as_dmdScheme(xml)
all.equal(dmdScheme_example(), x)


}
