% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.dnapath}
\alias{plot.dnapath}
\title{Plot function for 'dnapath' object.}
\usage{
\method{plot}{dnapath}(
  x,
  alpha = NULL,
  monotonized = FALSE,
  only_dc = FALSE,
  require_dc_genes = FALSE,
  scale_edges = 1,
  scale_nodes = 1,
  ...
)
}
\arguments{
\item{x}{A 'dnapath' object from \code{\link{dnapath}}.}

\item{alpha}{Threshold for p-values to infer differentially connected edges.
If NULL (the default) then no edges are removed from the plot.}

\item{monotonized}{If TRUE, monotonized (i.e. step-down) p-values from the
permutation test will be used.}

\item{only_dc}{If TRUE, only differentially connected edges will be shown;
any edges that are present in both groups are hidden. If FALSE, the edges
shared by both groups are shown. If a non-sparse estimator for network
edges is used, then the graph may be dense and setting this argument to TRUE
will be useful for highlighting the DC edges.}

\item{require_dc_genes}{If TRUE, the gene-level differential connectivity
p-value of the two genes for a given edge are also considered when deciding
whether an edge is differentially connected. If neither gene is significantly
differentially connected, then the edge between them will not be either.}

\item{scale_edges}{(Optional) multiplier for edge widths.}

\item{scale_nodes}{(Optional) multiplier for node radius}

\item{...}{Additional arguments are passed into the plotting function
\code{\link[SeqNet]{plot_network}}.}
}
\value{
Plots the differential network and returns the graph object.
See \code{\link[SeqNet]{plot_network}} for details.
}
\description{
Uses the plotting functions for networks from the \code{SeqNet} package
\insertCite{seqnet}{dnapath}
}
\examples{
data(meso)
data(p53_pathways)
set.seed(0)
results <- dnapath(x = meso$gene_expression, pathway_list = p53_pathways,
                   groups = meso$groups, n_perm = 10)
# Plot of the differential network for pathway 1.
plot(results[[1]]) 
# Plot of the differential network for pathway 1; remove any edges from
# the plot that have p-values above 0.1.
plot(results[[1]], alpha = 0.1) 
}
\references{
\insertRef{seqnet}{dnapath}
}
