% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction_plot.R
\name{interaction-plot}
\alias{interaction-plot}
\alias{interaction_plot}
\title{Two-way interaction plot}
\usage{
interaction_plot(.data, .formula, interval = "conf.int")
}
\arguments{
\item{.data}{A data frame}

\item{.formula}{A formula of the form \code{y ~ x1 + x2}}

\item{interval}{Either \code{conf.int}, \code{boxplot} or \code{none}}
}
\description{
Plots the mean of the response for
two-way combinations of factors, thereby illustrating possible
interactions.
}
\note{
This is a recent addition to the package and is subject to change.
}
\examples{

ToothGrowth |> interaction_plot(len ~ dose + supp)
ToothGrowth |> interaction_plot(len ~ dose + supp, interval="conf.int")
ToothGrowth |> interaction_plot(len ~ dose + supp, interval="boxplot")
ToothGrowth |> interaction_plot(len ~ dose + supp, interval="none")
}
