% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BY-transformBy.R
\name{by-transform}
\alias{by-transform}
\alias{transformBy}
\title{Function to make groupwise transformations}
\usage{
transformBy(formula, data, ...)
}
\arguments{
\item{formula}{A formula with only a right hand side, see examples below}

\item{data}{A data frame}

\item{\dots}{Further arguments of the form tag=value}
}
\value{
The modified value of the dataframe data.
}
\description{
Function to make groupwise transformations of data by applying
    the transform function to subsets of data.
}
\details{
The ... arguments are tagged vector expressions, which are evaluated
    in the data frame data. The tags are matched against names(data), and for
    those that match, the value replace the corresponding variable in data,
    and the others are appended to data.
}
\examples{
 
data(dietox)
transformBy(~Pig, data=dietox, minW=min(Weight), maxW=max(Weight), 
    gain=diff(range(Weight)))

}
\seealso{
\code{\link{orderBy}}, \code{\link{summaryBy}},
    \code{\link{splitBy}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{univar}
