% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiCons.R
\name{MultiCons}
\alias{MultiCons}
\title{MultiCons Consensus Clustering Algorithm}
\usage{
MultiCons(
  DB,
  Clust_entry = FALSE,
  Clustering_selection = c("kmeans", "pam", "OPTICS", "agghc", "AGNES", "DIANA",
    "MCLUST", "CMeans", "FANNY", "BaggedClust"),
  num_algo = 10,
  maxClust = 10,
  sim.indice = "Jaccard",
  returnAll = FALSE,
  Plot = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{DB}{Either data or dataframe of partitions.}

\item{Clust_entry}{Is DB partitions (\code{TRUE}) or data (\code{FALSE}).}

\item{Clustering_selection}{If DB is data, clustering algorithm to select
among. Must be included in default value.}

\item{num_algo}{Number of clustering algorithms to perform.}

\item{maxClust}{Maximum number of clusters.}

\item{sim.indice}{Index for defining best partition. Passed to
\code{clusterCrit::extCriteria)()}, see
\code{clusterCrit::getCriteriaNames(FALSE)} for other available indexes.
If more than one index are given, only the first one will be used.}

\item{returnAll}{Should all partitions (\code{TRUE}) or only the best
(\code{FALSE}) be returned.}

\item{Plot}{Should tree be plotted.}

\item{verbose}{Passed on to \code{mclust()} and other functions.}
}
\value{
A list of 2: performances and partitions. If \code{returnAll} is
\code{TRUE}, both elements of the list contain results for all levels of
the tree, else they only contain the results for the best level of
the tree.
}
\description{
Performs MultiCons clustering, from Al-Najdi et Al.
For some reason, if you want to use \code{mclust()} clustering, the package
needs to be loaded manually
}
\examples{
library(mclust)
### With clustering algorithm choices
MultiCons(iris[, 1:4],
          Clustering_selection = c("kmeans", "pam", "DIANA", "MCLUST"),
          Plot = TRUE)
### With a manual clustering entry
parts <- data.frame(factor(rep(c(1,2,3), each = 50)),
                    factor(rep(c(1,2,3), times = c(100, 25, 25))),
                    factor(rep(c(1,2), times = c(50, 100))),
                    factor(rep(c(3, 2, 1), times = c(120, 10, 20))),
                    stringsAsFactors = TRUE)
MultiCons(parts, Clust_entry = TRUE, Plot = TRUE)
}
