\name{registerDoParallel}
\alias{registerDoParallel}
\title{registerDoParallel}
\description{
The \code{registerDoParallel} function is used to register the 
parallel backend with the \code{foreach} package.
}
\usage{
registerDoParallel(cl, cores=NULL, \dots)
}
\arguments{
  \item{cl}{A cluster object as returned by \code{makeCluster}, or the number
  of nodes to be created in the cluster. If not specified, on Windows a 
  three worker cluster is created and used.}
  \item{cores}{The number of cores to use for parallel execution. If not
  specified, the number of cores is set to the value of 
  \code{options("cores")}, if specified, or to one-half the number of cores detected
  by the \code{parallel} package.}
  \item{\dots}{Package options.  Currently, only the \code{nocompile} option
  is supported.  If \code{nocompile} is set to \code{TRUE}, compiler
  support is disabled. If you are using \code{multicore}-like functionality, 
  multicore options are supported. If you are using \code{snow}-like 
  functionality, snow options are supported. }
}
\details{
The \code{parallel} package from R 2.14.0 and later provides functions for 
parallel execution of R code on machines with multiple cores or processors 
or multiple computers.  It is essentially a blend of the \code{snow} and 
\code{multicore} packages. By default, the \code{doParallel} package uses 
\code{snow}-like functionality.  The \code{snow}-like functionality
should work fine on Unix-like systems, but the \code{multicore}-like 
functionality is limited to a single sequential worker on Windows systems.
On workstations with multiple cores running Unix-like operating systems, 
the system \code{fork} call is used to spawn copies of the current process. 

The supported multicore options are \code{preschedule}, \code{set.seed},
\code{silent}, and \code{cores}, which are analogous to the similarly named 
arguments to \code{\link{mclapply}}. The supported snow option is 
\code{preschedule}, which like its multicore analog can be used to chunk the 
tasks so that each worker gets a prescheduled chunk of tasks.
}
\keyword{utilities}
