% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-contraction.R
\name{dodgr_contract_graph}
\alias{dodgr_contract_graph}
\title{dodgr_contract_graph}
\usage{
dodgr_contract_graph(graph, verts = NULL, nocache = FALSE)
}
\arguments{
\item{graph}{A flat table of graph edges. Must contain columns labelled
\code{from} and \code{to}, or \code{start} and \code{stop}. May also contain
similarly labelled columns of spatial coordinates (for example
\code{from_x}) or \code{stop_lon}).}

\item{verts}{Optional list of vertices to be retained as routing points.
These must match the \code{from} and \code{to} columns of \code{graph}.}

\item{nocache}{If \code{FALSE} (default), load cached version of contracted graph
if previously calculated and cached. If \code{TRUE}, then re-contract graph even
if previously calculated version has been stored in cache.}
}
\value{
A contracted version of the original \code{graph}, containing the same
number of columns, but with each row representing an edge between two
junction vertices (or between the submitted \code{verts}, which may or may not be
junctions).
}
\description{
Removes redundant (straight-line) vertices from graph, leaving only junction
vertices.
}
\examples{
graph <- weight_streetnet (hampi)
nrow (graph) # 5,973
graph <- dodgr_contract_graph (graph)
nrow (graph) # 662
}
\seealso{
Other modification: 
\code{\link{dodgr_components}()},
\code{\link{dodgr_uncontract_graph}()}
}
\concept{modification}
