% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daFitFunctions.r
\name{using-fit-indices}
\alias{using-fit-indices}
\title{Provides fit indices for different regression models.}
\arguments{
\item{data}{Complete data set containing the variables in the model.}

\item{null.model}{Null model only needed for HLM models.}

\item{base.cov}{Required if only a covariance/correlation matrix is provided.}

\item{family.glm}{family param for glm models.}
}
\description{
\code{\link{dominanceAnalysis}} tries to infer, based on the class of the
model provided, the appropriate fit indices, using the scheme
da.CLASS.fit for name. This method has two interfaces, one for retrieving
the names of the fit indices, and another to retrieve the indices based
on the data.
}
\details{
Interfaces are:
\itemize{
\item \code{da.CLASS.fit("names")} returns a vector with names for fit indices
\item \code{da.CLASS.fit(data, null.model, base.cov=NULL,family.glm=NULL)} returns a function with one parameter, the formula to calculate the submodel.
}
}
