% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/count_test-class.R
\docType{class}
\name{count_test}
\alias{coef,count_test-method}
\alias{count_test}
\alias{count_test-class}
\alias{plot,count_test,ANY-method}
\alias{plot,count_test-method}
\alias{plot.count_test}
\alias{show,count_test-method}
\alias{summary,count_test-method}
\title{Class \code{"count_test"}}
\usage{
\S4method{summary}{count_test}(object)

\S4method{coef}{count_test}(object)

\S4method{show}{count_test}(object)

\S4method{plot}{count_test,ANY}(x, aggregate = FALSE, nice = TRUE)
}
\arguments{
\item{object}{of class \code{count_test}.}

\item{x}{object of class \code{count_test}.}

\item{aggregate}{logical, if \code{TRUE} experiments are aggregated according
to their group.}

\item{nice}{logical, if \code{TRUE} a more aesthetically pleasing (but harder to
customize) version of the plot is created.}
}
\description{
Objects of this class are created by \code{\link{test_counts}}.
}
\details{
In case of aggregated plot, mean confidence intervals for groups are presented
as dashed lines.
}
\section{Methods (by generic)}{
\itemize{
\item \code{summary}: Summary statistics of assigned groups.

\item \code{coef}: Extract coefficients of groups.

\item \code{show}: Print both \code{group_coef} and \code{t_res}.

\item \code{plot}: plots mean number of molecules per partition and its confidence intervals.
}}
\section{Slots}{

\describe{
\item{group_coef}{\code{"data.frame"} containing experiments, groups to which they
belong and calculated values of rate (lambda).}
\item{t_res}{\code{"matrix"} containing result of multiple comparisions t-test.}
\item{model}{\code{"character"} name of GLM used to compare experiments.} }
}
\author{
Michal Burdukiewicz.
}
\seealso{
\code{\link{test_counts}}.
}
\keyword{classes}

