% Generated by roxygen2 (4.0.2): do not edit by hand
\name{summarise}
\alias{summarise}
\alias{summarise_}
\alias{summarize}
\alias{summarize_}
\title{Summarise multiple values to a single value.}
\usage{
summarise(.data, ...)

summarise_(.data, ..., .dots)

summarize(.data, ...)

summarize_(.data, ..., .dots)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link{tbl_df}}, \code{\link{tbl_dt}} and \code{\link{tbl_sql}}.}

\item{...}{Name-value pairs of summary functions like \code{\link{min}()},
\code{\link{mean}()}, \code{\link{max}()} etc.}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse")} for details.}
}
\value{
An object of the same class as \code{.data}. One grouping level will
  be dropped.

  Data frame row names are silently dropped. To preserve, convert to an
  explicit variable.
}
\description{
Summarise multiple values to a single value.
}
\examples{
summarise(mtcars, mean(disp))
summarise(group_by(mtcars, cyl), mean(disp))

summarise(group_by(mtcars, cyl), m = mean(disp), sd = sd(disp))
}
\seealso{
Other single.table.verbs: \code{\link{arrange}},
  \code{\link{arrange_}}; \code{\link{filter}},
  \code{\link{filter_}}; \code{\link{mutate}},
  \code{\link{mutate_}}, \code{\link{transmute}},
  \code{\link{transmute_}}; \code{\link{rename}},
  \code{\link{rename_}}, \code{\link{select}},
  \code{\link{select_}}; \code{\link{slice}},
  \code{\link{slice_}}
}

