% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manip.r
\name{mutate}
\alias{mutate}
\alias{mutate_}
\alias{transmute}
\alias{transmute_}
\title{Add new variables.}
\usage{
mutate(.data, ...)

mutate_(.data, ..., .dots)

transmute(.data, ...)

transmute_(.data, ..., .dots)
}
\arguments{
\item{.data}{A tbl. All main verbs are S3 generics and provide methods
for \code{\link{tbl_df}}, \code{\link[dtplyr]{tbl_dt}} and \code{\link{tbl_sql}}.}

\item{...}{Name-value pairs of expressions. Use \code{NULL} to drop
a variable.}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse")} for details.}
}
\value{
An object of the same class as \code{.data}.

  Data frame row names are silently dropped. To preserve, convert to an
  explicit variable.
}
\description{
Mutate adds new variables and preserves existing; transmute drops existing
variables.
}
\examples{
mutate(mtcars, displ_l = disp / 61.0237)
transmute(mtcars, displ_l = disp / 61.0237)

mutate(mtcars, cyl = NULL)
}
\seealso{
Other single.table.verbs: \code{\link{arrange}},
  \code{\link{filter}}, \code{\link{select}},
  \code{\link{slice}}, \code{\link{summarise}}
}

