% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-diagnose.R
\name{diagnose}
\alias{diagnose}
\title{Get diagnostic metadata on a target.}
\usage{
diagnose(target = NULL, character_only = FALSE, path = getwd(),
  search = TRUE, cache = drake::get_cache(path = path, search = search,
  verbose = verbose), verbose = 1L)
}
\arguments{
\item{target}{Name of the target of the error to get.
Can be a symbol if \code{character_only} is \code{FALSE},
must be a character if \code{character_only} is \code{TRUE}.}

\item{character_only}{Logical, whether \code{target} should be treated
as a character or a symbol.
Just like \code{character.only} in \code{\link[=library]{library()}}.}

\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}
}
\value{
Either a character vector of target names or an object
of class \code{"error"}.
}
\description{
Diagnostics include errors, warnings,
messages, runtimes, and other context/metadata from when a
target was built or an import was processed.
If your target's last build succeeded,
then \code{diagnose(your_target)} has the most current information
from that build.
But if your target failed, then only
\code{diagnose(your_target)$error},
\code{diagnose(your_target)$warnings},
and \code{diagnose(your_target)$messages} correspond to the failure,
and all the other metadata correspond to the last build that completed
without an error.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
diagnose() # List all the targets with recorded error logs.
# Define a function doomed to failure.
f <- function() {
  stop("unusual error")
}
# Create a workflow plan doomed to failure.
bad_plan <- drake_plan(my_target = f())
# Running the project should generate an error
# when trying to build 'my_target'.
try(make(bad_plan), silent = FALSE)
failed() # List the failed targets from the last make() (my_target).
# List targets that failed at one point or another
# over the course of the project (my_target).
# drake keeps all the error logs.
diagnose()
# Get the error log, an object of class "error".
error <- diagnose(my_target)$error # See also warnings and messages.
str(error) # See what's inside the error log.
error$calls # View the traceback. (See the traceback() function).
suppressWarnings(
  make(
    drake_plan(
      x = 1,
      y = warning(123),
      z = warning(456)
    ),
    verbose = FALSE
  )
)
targets <- built(verbose = FALSE)
out <- lapply(targets, diagnose, character_only = TRUE, verbose = FALSE)
names(out) <- targets
unlist(out)
})
}
}
\seealso{
\code{\link[=failed]{failed()}}, \code{\link[=progress]{progress()}},
\code{\link[=readd]{readd()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
