% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{drake_get_session_info}
\alias{drake_get_session_info}
\title{Session info of the last call to \code{\link[=make]{make()}}.
\lifecycle{maturing}}
\usage{
drake_get_session_info(path = NULL, search = NULL,
  cache = drake::drake_cache(path = path), verbose = 1L)
}
\arguments{
\item{path}{Path to a \code{drake} cache
(usually a hidden \code{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{verbose}{Deprecated on 2019-09-11.}
}
\value{
\code{\link[=sessionInfo]{sessionInfo()}} of the last
call to \code{\link[=make]{make()}}
}
\description{
By default, session info is saved
during \code{\link[=make]{make()}} to ensure reproducibility.
Your loaded packages and their versions are recorded, for example.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
drake_get_session_info() # Get the cached sessionInfo() of the last make().
}
})
}
}
\seealso{
\code{\link[=diagnose]{diagnose()}}, \code{\link[=cached]{cached()}},
\code{\link[=readd]{readd()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
