% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_partial_effect.R
\name{drape}
\alias{drape}
\title{Estimate the doubly-robust average partial effect estimate of X on Y, in the presence of Z.}
\usage{
drape(
  y,
  x,
  z,
  response_regression,
  predictor_regression,
  resmooth_bw = NULL,
  spline_df = NULL,
  nfolds = 5L,
  foldid = NULL,
  verbose = FALSE
)
}
\arguments{
\item{y}{vector of responses.}

\item{x}{vector of the predictor of interest.}

\item{z}{matrix of additional predictors.}

\item{response_regression}{function which takes input data of the form
(X,y), where X=cbind(x,z), and returns a prediction function f:X -> y and optionally a
similar derivative estimation function (in this case no resmoothing is done).}

\item{predictor_regression}{function which takes input data of the form
(z,x), and returns a prediction function m:z -> x.}

\item{resmooth_bw}{optional numeric to be used as resmoothing bandwidth,
otherwise chosen via cross-validation. Only used if
response_regression doesn't predict derivatives.}

\item{spline_df}{optional double, a smoothing parameter for the
unconditional spline score estimator, corresponding to the effective degrees
of freedom for a smoothing spline. If NULL, chosen via
cross-validation.}

\item{nfolds}{integer, number of sample-splits. If set to
one, then all data is used for both training and evaluation.}

\item{foldid}{optional vector with components in 1:nfolds indicating the folds in which
each observation fell. Overwrites nfolds.}

\item{verbose}{boolean controlling level of information outputted.}
}
\value{
list containing the average partial effect estimate and the
corresponding standard error estimate. If verbose=TRUE, additionally contains
variables used in computations.
}
\description{
Estimate the doubly-robust average partial effect estimate of X on Y, in the presence of Z.
}
\examples{
set.seed(0)
data <- simulate_data(200, "normal", "plm")
response_regression <- function(X,y){
    df <- data.frame(y,X)
    colnames(df) <- c("y", paste0("X", 1:10))
    lm1 <- stats::lm(y~X1+sin(X2), data=df)
    fit <- function(newX){
        newdf <- data.frame(newX)
        colnames(newdf) <- paste0("X", 1:10)
        return(as.vector(stats::predict(lm1, newdata=newdf)))}
    return(list("fit"=fit))
}
predictor_regression <- function(z,x){
    df <- data.frame(x,z)
    colnames(df) <- c("x", paste0("Z", 1:9))
    lm1 <- stats::lm(x~Z1+Z2, data=df)
    fit <- function(newz){
        newdf <- data.frame(newz)
        colnames(newdf) <- paste0("Z", 1:9)
        return(as.vector(stats::predict(lm1, newdata=newdf)))}
    return(list("fit"=fit))
}
drape(data$y, data$x, data$z, response_regression, predictor_regression, nfolds=2)
}
