% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trialdev.R
\name{trialdev}
\alias{trialdev}
\title{Calculates trial deviation for simulated trials (drops).}
\usage{
trialdev(sim.values)
}
\arguments{
\item{sim.values}{Data table. Data table produced by droptest::dtrials, 
droptest::dseries, or droptest::dgroups.}
}
\value{
Data table of q, p, trial deviation, and average total trials per
  test. Aggregated by q.
  
\itemize{
 \item \strong{Q} The probability of failure (reaction) as specified.
 
 \item \strong{P} The probability of success (non-reaction).
 
 \item \strong{TRIAL_DEV} The average distance from q for the total percent
  of reactions (failures).
  
 \item \strong{AVG_TRIALS} The average number of simulated trials reached
  for each q.
}
}
\description{
\code{trialdev} creates a data.table with the average distances from q for
the total percent of reactions (failures).
}
\examples{
  trialdev(dtrials(q = 0.05, max.trials = 60, fail.criteria = 2))

}
\seealso{
\code{\link{dtrials}}
 \code{\link{dseries}}
 \code{\link{dgroups}}
 \code{\link{droptest}}
}
\author{
Chad Ross \email{chad.ross@gmail.com}
}
