% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimal_multitrial_binary.R
\name{optimal_multitrial_binary}
\alias{optimal_multitrial_binary}
\title{Optimal phase II/III drug development planning where several phase III trials are performed}
\usage{
optimal_multitrial_binary(
  w,
  p0,
  p11,
  p12,
  in1,
  in2,
  n2min,
  n2max,
  stepn2,
  rrgomin,
  rrgomax,
  steprrgo,
  alpha,
  beta,
  c2,
  c3,
  c02,
  c03,
  K = Inf,
  N = Inf,
  S = -Inf,
  b1,
  b2,
  b3,
  case,
  strategy = TRUE,
  fixed = FALSE,
  num_cl = 1
)
}
\arguments{
\item{w}{weight for \href{https://web.imbi.uni-heidelberg.de/prior/}{mixture prior distribution}}

\item{p0}{assumed true rate of control group, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{p11}{assumed true rate of treatment group, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{p12}{assumed true rate of treatment group, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{in1}{amount of information for \code{p11} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{in2}{amount of information for \code{p12} in terms of sample size, see
\href{https://web.imbi.uni-heidelberg.de/prior/}{here}
for details}

\item{n2min}{minimal total sample size for phase II; must be an even number}

\item{n2max}{maximal total sample size for phase II, must be an even number}

\item{stepn2}{step size for the optimization over n2; must be an even number}

\item{rrgomin}{minimal threshold value for the go/no-go decision rule}

\item{rrgomax}{maximal threshold value for the go/no-go decision rule}

\item{steprrgo}{step size for the optimization over RRgo}

\item{alpha}{one-sided significance level}

\item{beta}{type II error rate; i.e. \code{1 - beta} is the power for calculation of the number of events for phase III}

\item{c2}{variable per-patient cost for phase II in 10^5 $}

\item{c3}{variable per-patient cost for phase III in 10^5 $}

\item{c02}{fixed cost for phase II in 10^5 $}

\item{c03}{fixed cost for phase III in 10^5 $}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{b1}{expected gain for effect size category "small"}

\item{b2}{expected gain for effect size category "medium"}

\item{b3}{expected gain for effect size category "large"}

\item{case}{choose case: "at least 1, 2 or 3 significant trials needed for approval"}

\item{strategy}{choose strategy: "conduct 1, 2, 3 or 4 trials in order to achieve the case's goal"; TRUE calculates all strategies of the selected \code{case}}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE p11 is used as fixed effect for p1}

\item{num_cl}{number of clusters used for parallel computing, default: 1}
}
\value{
The output of the function is a \code{data.frame} object containing the optimization results:
\describe{\item{Case}{Case: "number of significant trials needed"}\item{Strategy}{Strategy: "number of trials to be conducted in order to achieve the goal of the case"}\item{u}{maximal expected utility under the optimization constraints, i.e. the expected utility of the optimal sample size and threshold value}\item{RRgo}{optimal threshold value for the decision rule to go to phase III}\item{n2}{total sample size for phase II; rounded to the next even natural number}
\item{n3}{total sample size for phase III; rounded to the next even natural number}
\item{n}{total sample size in the program; n = n2 + n3}
\item{K}{maximal costs of the program (i.e. the cost constraint, if it is set or the sum K2+K3 if no cost constraint is set)}
\item{pgo}{probability to go to phase III}
\item{sProg}{probability of a successful program}\item{sProg1}{probability of a successful program with "small" treatment effect in phase III (lower boundary in HR scale is set to 1, as proposed by IQWiG (2016))}
\item{sProg2}{probability of a successful program with "medium" treatment effect in phase III (lower boundary in HR scale is set to 0.95, as proposed by IQWiG (2016))}
\item{sProg3}{probability of a successful program with "large" treatment effect in phase III (lower boundary in HR scale is set to 0.85, as proposed by IQWiG (2016))}\item{K2}{expected costs for phase II}
\item{K3}{expected costs for phase III}}
and further input parameters. Taking \code{cat(comment())} of the
data frame lists the used optimization sequences, start and
finish date of the optimization procedure.
}
\description{
The \code{optimal_multitrial_binary} function enables planning of phase II/III
drug development programs with several phase III trials for the same
binary endpoint. The main output values are optimal sample size allocation
and go/no-go decision rules. For binary endpoints, the treatment effect is
measured by the risk ratio (RR).
}
\details{
The assumed true treatment effects can be assumed fixed or modelled by a
prior distribution. The R Shiny application
\href{https://web.imbi.uni-heidelberg.de/prior/}{prior} visualizes the prior
distributions used in this package.

Fast computing is enabled by parallel programming.
}
\section{Effect sizes}{

In other settings, the definition of "small", "medium" and "large" effect
sizes can be user-specified using the input parameters \code{steps1}, \code{stepm1} and
\code{stepl1}. Due to the complexity of the multitrial setting, this feature is
not included for this setting. Instead, the effect sizes were set to
to predefined values as explained under sProg1, sProg2 and sProg3 in the
\emph{Value} section.
}

\examples{
# Activate progress bar (optional)
\dontrun{progressr::handlers(global = TRUE)}
# Optimize
\donttest{
optimal_multitrial_binary(w = 0.3,         # define parameters for prior
  p0 = 0.6, p11 =  0.3, p12 = 0.5,
  in1 = 30, in2 = 60,                             # (https://web.imbi.uni-heidelberg.de/prior/)
  n2min = 20, n2max = 100, stepn2 = 4,            # define optimization set for n2
  rrgomin = 0.7, rrgomax = 0.9, steprrgo = 0.05,  # define optimization set for RRgo
  alpha = 0.025, beta = 0.1,                      # drug development planning parameters
  c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,        # fixed and variable costs for phase II/III,
  K = Inf, N = Inf, S = -Inf,                     # set constraints
  b1 = 1000, b2 = 2000, b3 = 3000,                # expected benefit for a each effect size
  case = 1, strategy = TRUE,                      # chose Case and Strategy                                   
  fixed = TRUE,                                   # true treatment effects are fixed/random
  num_cl = 1)                                     # number of cores for parallelized computing
  }
}
\references{
IQWiG (2016). Allgemeine Methoden. Version 5.0, 10.07.2016, Technical Report. Available at \href{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}{https://www.iqwig.de/ueber-uns/methoden/methodenpapier/}, assessed last 15.05.19.
}
