% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{transl33t}
\alias{transl33t}
\title{transl33t text into leet slang (using stringr).}
\usage{
transl33t(txt, rules = l33t_rul35, in_case = "no", out_case = "no")
}
\arguments{
\item{txt}{The text (character string) to translate.}

\item{rules}{Rules which existing character in \code{txt} 
is to be replaced by which new character (as named character vector). 
Default: \code{rules = \link{l33t_rul35}}.}

\item{in_case}{Change case of input string \code{txt}. 
Default: \code{in_case = "no"}. 
Set to \code{"lo"} or \code{"up"} for lower or uppercase, respectively.}

\item{out_case}{Change case of output string. 
Default: \code{out_case = "no"}. 
Set to \code{"lo"} or \code{"up"} for lower or uppercase, respectively.}
}
\description{
\code{transl33t} translates text into leet (or l33t) slang 
given a set of rules and the \bold{stringr} package.
}
\examples{
# Use defaults:
transl33t(txt = "hello world")
transl33t(txt = c(letters))
transl33t(txt = c(LETTERS))

# Specify rules:
transl33t(txt = "hello world", 
          rules = c("e" = "3", "l" = "1", "o" = "0"))

# Set input and output case:
transl33t(txt = "hello world", in_case = "up", 
          rules = c("e" = "3", "l" = "1", "o" = "0"))
transl33t(txt = "hello world", out_case = "up", 
          rules = c("e" = "3", "l" = "1", "o" = "0"))

}
\seealso{
\code{\link{l33t_rul35}} for default rules.

Other text functions: \code{\link{l33t_rul35}}
}
\concept{text functions}
