% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_fun.R
\name{sample_times}
\alias{sample_times}
\title{Draw a sample of n random times (from a given range).}
\usage{
sample_times(n = 1, from = "1970-01-01 00:00:00", to = Sys.time())
}
\arguments{
\item{n}{Number dates to draw. 
Default: \code{n = 1}.}

\item{from}{Earliest date (as string). 
Default: \code{from = "1970-01-01 00:00:00"}.}

\item{to}{Latest date (as string). 
Default: \code{to = Sys.time()}.}
}
\description{
\code{sample_times} draws a sample of  
\code{n} random times from a given range.
}
\details{
By default, \code{sample_times} draws \code{n = 1} 
random time in the range 
\code{from = "1970-01-01 00:00:00"} 
\code{to = Sys.time()} (current time).
}
\examples{
# Basics:
sample_times()
sample_times(n = 10)

# Specific ranges:
sort(sample_times(n = 10, from = (Sys.time() - 60)))  # within the last minute
sort(sample_times(n = 10, from = (Sys.time() - 1 * 60 * 60)))  # within the last hour
sort(sample_times(n = 10, from = Sys.time(), 
                            to = (Sys.time() + 1 * 60 * 60)))  # within the next hour
sort(sample_times(n = 10, from = "2020-01-01 00:00:00 CET", 
                            to = "2020-01-01 00:00:01 CET"))  # within 1 sec range
 
# Note: Oddity with sample(): 
sort(sample_times(n = 10, from = "2020-01-01 00:00:00 CET", 
                            to = "2020-01-01 00:00:00 CET"))  # range of 0!
# see sample(9:9, size = 10, replace = TRUE)

}
\seealso{
Other random functions: 
\code{\link{coin}()},
\code{\link{dice_2}()},
\code{\link{dice}()},
\code{\link{sample_dates}()}
}
\concept{random functions}
