% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_fun.R
\name{change_time}
\alias{change_time}
\title{Change time and time zone (without changing time display).}
\usage{
change_time(time, tz = "")
}
\arguments{
\item{time}{Time (as a scalar or vector).
If \code{time} is not a local time (of the "POSIXlt" class) 
the function first tries coercing \code{time} into "POSIXlt" 
without changing the time display.}

\item{tz}{Time zone (as character string).
Default: \code{tz = ""} 
(i.e., current system time zone, \code{Sys.timezone()}). 
See \code{OlsonNames()} for valid options.}
}
\value{
A calendar time of class "POSIXct".
}
\description{
\code{change_time} changes the time and time zone  
without changing the time display.
}
\details{
\code{change_time} expects inputs to \code{time} 
to be local time(s) (of the "POSIXlt" class) 
and a valid time zone argument \code{tz} (as a string)
and returns the same time display (but different actual times) 
as calendar time(s) (of the "POSIXct" class).
}
\examples{
change_time(as.POSIXlt(Sys.time()), tz = "UTC")

# from "POSIXlt" time:
t1 <- as.POSIXlt("2020-01-01 10:20:30", tz = "Europe/Berlin")
change_time(t1, "NZ")
change_time(t1, "US/Pacific")

# from "POSIXct" time:
tc <- as.POSIXct("2020-07-01 12:00:00", tz = "UTC")
change_time(tc, "NZ")

# from "Date":
dt <- as.Date("2020-12-31", tz = "US/Hawaii")
change_time(dt, tz = "NZ")

# from time "string":
ts <- "2020-12-31 20:30:45"
change_time(ts, tz = "US/Pacific")

# from other "string" times:
tx <- "7:30:45"
change_time(tx, tz = "Asia/Calcutta")
ty <- "1:30"
change_time(ty, tz = "Europe/London")

# convert into local times:
(l1 <- as.POSIXlt("2020-06-01 10:11:12"))
change_tz(change_time(l1, "NZ"), tz = "UTC")
change_tz(change_time(l1, "Europe/Berlin"), tz = "UTC")
change_tz(change_time(l1, "US/Eastern"), tz = "UTC")

# with vector of "POSIXlt" times:
(l2 <- as.POSIXlt("2020-12-31 23:59:55", tz = "US/Pacific"))
(tv <- c(l1, l2))              # uses tz of l1
change_time(tv, "US/Pacific")  # change time and tz
 
}
\seealso{
\code{\link{change_tz}} function which preserves time but changes time display; 
\code{Sys.time()} function of \strong{base} R.

Other date and time functions: 
\code{\link{change_tz}()},
\code{\link{cur_date}()},
\code{\link{cur_time}()},
\code{\link{days_in_month}()},
\code{\link{diff_dates}()},
\code{\link{diff_times}()},
\code{\link{diff_tz}()},
\code{\link{is_leap_year}()},
\code{\link{what_date}()},
\code{\link{what_month}()},
\code{\link{what_time}()},
\code{\link{what_wday}()},
\code{\link{what_week}()},
\code{\link{what_year}()},
\code{\link{zodiac}()}
}
\concept{date and time functions}
