% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outlier.R
\name{outlier}
\alias{outlier}
\title{Outlier adjustment of daily time series}
\usage{
outlier(
  series,
  model,
  cval = 7,
  types = c("AO", "LS", "TC"),
  maxit.oloop = 1,
  maxit.iloop = 2,
  maxit.endloop = 1000,
  holidays = NULL,
  number.fourier = 13
)
}
\arguments{
\item{series}{Input time series}

\item{model}{ARIMA model used}

\item{cval}{Critical Value for outlier Detection}

\item{types}{Types of Outliers included. "AO", "LS", "TC" and "IO" permitted.}

\item{maxit.oloop}{Maximum iterations of the outer loop}

\item{maxit.iloop}{Maximum iterations of the inner loop}

\item{maxit.endloop}{Maximum iterations of the end loop.}

\item{holidays}{Holiday regressors used in regARIMA}

\item{number.fourier}{Number of trigonometric regressors used to model seasonality}
}
\description{
Outlier adjust any daily time series with an algorithm similar to that used in TRAMO. This function draws heavily from the tsoutliers package by Javier López-de-Lacalle.
}
\details{
This function is used internally in dsa()
}
\examples{
set.seed(356)
x <- arima.sim(list(order = c(1,1,0), ar = 0.7), n = 365*4)
timeseries <- ts(x, freq=365, start=c(2001,1))
shocks <- rbinom(length(timeseries), 1, 0.002) * 1.5 * timeseries
timeseries <- timeseries + shocks
modelfit <- arima(timeseries, order = c(1,1,0))
out <- outlier(timeseries, model=modelfit, cval=8)
ts.plot(timeseries, out$series_adj, col=c("red", "black"))
Names = c("Original Series", "Outlier Adjusted")
legend(2004.2, 140, Names, col=c("red", "black"), lty=1, bty="n", cex=0.75)
}
\references{
López-de-Lacalle, Javier (2017). R package tsoutliers.
}
