% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tau.R
\name{get_tau}
\alias{get_tau}
\title{Obtain difficulty parameters from item bank}
\usage{
get_tau(items, key = NULL, itembank = dscore::builtin_itembank)
}
\arguments{
\item{items}{A character vector containing names of items to be
included into the D-score calculation. Milestone scores are coded
numerically as \code{1} (pass) and \code{0} (fail). By default,
D-score calculation is done on all items found in the data
that have a difficulty parameter under the specified \code{key}.}

\item{key}{A string that selects a subset in the itembank that
makes up the key, the set of difficulty
estimates from a fitted Rasch model.
The built-in keys are:  \code{"gsed2212"} (default), \code{"gsed2208"} (deprecated),
\code{"gsed2206"} (deprecated), \code{"gsed1912"}, \code{"lf2206"}, \code{"sf2206"}, \code{"gcdg"},
and \code{"dutch"}. Since version 1.5.0, the \code{key = "gsed"}
selects the latest key starting with the string "gsed".
Use \code{key = ""} to use all item names,
which should only be done if there are no duplicate itemnames
in the itembank.}

\item{itembank}{A \code{data.frame} with columns
\code{key}, \code{item}, \code{tau}, \code{instrument}, \code{domain},
\code{mode}, \code{number} and \code{label}. Only columns \code{item}
and \code{tau} are required.
The function uses \code{dscore::builtin_itembank} by
default.}
}
\value{
A named vector with the difficulty estimate per item with
\code{length(items)} elements.
}
\description{
Searches the item bank for matching items, and returns the
difficulty estimates. Matching is done by item name. Comparisons
are done in lower case.
}
\examples{
# difficulty levels in the GHAP lexicon
get_tau(items = c("ddifmd001", "DDigmd052", "xyz"))
}
\seealso{
\code{\link[=builtin_itembank]{builtin_itembank()}}, \code{\link[=dscore]{dscore()}}
}
\author{
Stef van Buuren 2020
}
