% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.concurvity.R
\name{vis.concurvity}
\alias{vis.concurvity}
\title{Visualise concurvity between terms in a GAM}
\usage{
vis.concurvity(model, type = "estimate")
}
\arguments{
\item{model}{fitted model}

\item{type}{concurvity measure to plot, see \code{\link{concurvity}}}
}
\description{
Plot measures of how much one term in the model could be explained by another. When values are high, one should consider re-running variable selection with one of the offending variables removed to check for stability in term selection.
}
\details{
These methods are considered somewhat experimental at this time. Consult \code{\link{concurvity}} for more information on how concurvity measures are calculated.
}
\examples{
\dontrun{
library(Distance)
library(dsm)

# load the Gulf of Mexico dolphin data (see ?mexdolphins)
data(mexdolphins)

# fit a detection function and look at the summary
hr.model <- ds(distdata, max(distdata$distance),
               key = "hr", adjustment = NULL)

# fit a simple smooth of x and y to counts
mod1 <- dsm(count~s(x,y)+s(depth), hr.model, segdata, obsdata)

# visualise concurvity using the "estimate" metric
vis.concurvity(mod1)
}
}
\author{
David L Miller
}
