# fit_dsmm() non parametric estimation; p and f are drifting

    Code
      obj_model_1
    Output
      
      
      
      $dist$p_drift
      
      , , p_0
      
                a         c         g         t
      a 0.0000000 0.2928374 0.3717104 0.3354522
      c 0.3023716 0.0000000 0.3962073 0.3014211
      g 0.3436550 0.3047510 0.0000000 0.3515940
      t 0.3325151 0.2558372 0.4116477 0.0000000
      
      , , p_(1/3)
      
                a         c         g         t
      a 0.0000000 0.3684005 0.3296269 0.3019726
      c 0.3520526 0.0000000 0.3391474 0.3088001
      g 0.3714217 0.3247288 0.0000000 0.3038496
      t 0.3554353 0.3402464 0.3043183 0.0000000
      
      , , p_(2/3)
      
                a         c         g         t
      a 0.0000000 0.3088205 0.3285419 0.3626376
      c 0.3434957 0.0000000 0.3389797 0.3175246
      g 0.3208303 0.3117509 0.0000000 0.3674188
      t 0.3407074 0.2749527 0.3843399 0.0000000
      
      , , p_1
      
                a         c         g         t
      a 0.0000000 0.3918856 0.3910772 0.2170372
      c 0.3454498 0.0000000 0.3041657 0.3503845
      g 0.3226336 0.3867389 0.0000000 0.2906275
      t 0.3444807 0.3937185 0.2618008 0.0000000
      
      
      
      
      $dist$f_drift
      
      , , l = 1, f_0
      
                a         c         g         t
      a 0.0000000 0.7901328 0.6937341 0.9168894
      c 0.6063477 0.0000000 0.8197100 0.7144069
      g 0.6644908 0.7497707 0.0000000 0.7786443
      t 0.8231650 0.7519020 0.7267143 0.0000000
      
      , , l = 2, f_0
      
                a         c         g         t
      a 0.0000000 0.1795942 0.2045875 0.0590463
      c 0.3051466 0.0000000 0.1177530 0.1755653
      g 0.2487514 0.2350138 0.0000000 0.1477476
      t 0.1261540 0.2456668 0.2121029 0.0000000
      
      , , l = 3, f_0
      
                 a            c          g           t
      a 0.00000000 0.0064975233 0.08812030 0.001311742
      c 0.04843243 0.0000000000 0.04110996 0.072231442
      g 0.05294269 0.0013697112 0.00000000 0.068673117
      t 0.04671494 0.0005535745 0.04746970 0.000000000
      
      , , l = 4, f_0
      
                  a           c            g           t
      a 0.000000000 0.013001245 0.0004897316 0.002611603
      c 0.009695910 0.000000000 0.0214270548 0.002758149
      g 0.027243925 0.008015025 0.0000000000 0.002609832
      t 0.003966075 0.001826416 0.0131941395 0.000000000
      
      , , l = 5, f_0
      
                  a            c          g           t
      a 0.000000000 1.077420e-02 0.01306832 0.016106136
      c 0.030377356 0.000000e+00 0.00000000 0.021690629
      g 0.003303159 4.246079e-03 0.00000000 0.001283716
      t 0.000000000 5.116206e-05 0.00000000 0.000000000
      
      , , l = 6, f_0
      
                  a c            g           t
      a 0.000000000 0 0.0000000000 0.004034844
      c 0.000000000 0 0.0000000000 0.000000000
      g 0.003268051 0 0.0000000000 0.001041519
      t 0.000000000 0 0.0005189207 0.000000000
      
      , , l = 7, f_0
      
        a           c g          t
      a 0 0.000000000 0 0.00000000
      c 0 0.000000000 0 0.01334759
      g 0 0.001584681 0 0.00000000
      t 0 0.000000000 0 0.00000000
      
      , , l = 1, f_(1/3)
      
                a         c         g         t
      a 0.0000000 0.7612799 0.7518213 0.7066642
      c 0.7631653 0.0000000 0.7202603 0.7811277
      g 0.7555065 0.7043263 0.0000000 0.7554843
      t 0.7515527 0.7982977 0.7967939 0.0000000
      
      , , l = 2, f_(1/3)
      
                a         c         g         t
      a 0.0000000 0.1661836 0.1912965 0.1943938
      c 0.1592601 0.0000000 0.2001870 0.1621669
      g 0.1822475 0.2211870 0.0000000 0.1874509
      t 0.2031794 0.1445212 0.1636006 0.0000000
      
      , , l = 3, f_(1/3)
      
                 a          c          g          t
      a 0.00000000 0.05192429 0.04274673 0.07841241
      c 0.06339988 0.00000000 0.06937938 0.04213349
      g 0.03197207 0.06320993 0.00000000 0.04013910
      t 0.03558909 0.04872664 0.03444640 0.00000000
      
      , , l = 4, f_(1/3)
      
                  a           c           g          t
      a 0.000000000 0.016651651 0.008233620 0.01463932
      c 0.013144266 0.000000000 0.010173331 0.01157907
      g 0.022348467 0.004166118 0.000000000 0.01151347
      t 0.009678814 0.003963982 0.003224121 0.00000000
      
      , , l = 5, f_(1/3)
      
                  a           c           g            t
      a 0.000000000 0.003960512 0.005901915 0.0010016151
      c 0.001030513 0.000000000 0.000000000 0.0022112119
      g 0.003511931 0.004700674 0.000000000 0.0004058857
      t 0.000000000 0.004490487 0.000000000 0.0000000000
      
      , , l = 6, f_(1/3)
      
                  a c           g           t
      a 0.000000000 0 0.000000000 0.004888717
      c 0.000000000 0 0.000000000 0.000000000
      g 0.004413552 0 0.000000000 0.005006397
      t 0.000000000 0 0.001934993 0.000000000
      
      , , l = 7, f_(1/3)
      
        a           c g            t
      a 0 0.000000000 0 0.0000000000
      c 0 0.000000000 0 0.0007816748
      g 0 0.002410059 0 0.0000000000
      t 0 0.000000000 0 0.0000000000
      
      , , l = 1, f_(2/3)
      
                a         c         g         t
      a 0.0000000 0.7386446 0.7378505 0.7533718
      c 0.7833693 0.0000000 0.7586445 0.7310639
      g 0.7528406 0.7276847 0.0000000 0.7865006
      t 0.7360867 0.8050546 0.7719600 0.0000000
      
      , , l = 2, f_(2/3)
      
                a         c         g         t
      a 0.0000000 0.2106506 0.1823445 0.1728485
      c 0.1575551 0.0000000 0.1766604 0.1961211
      g 0.1817574 0.2035716 0.0000000 0.1573527
      t 0.1833138 0.1500540 0.1567797 0.0000000
      
      , , l = 3, f_(2/3)
      
                 a          c          g          t
      a 0.00000000 0.02194799 0.06371970 0.05434872
      c 0.04837279 0.00000000 0.05114615 0.06190707
      g 0.05595639 0.03785489 0.00000000 0.04509583
      t 0.07658024 0.03939081 0.06288726 0.00000000
      
      , , l = 4, f_(2/3)
      
                  a           c           g           t
      a 0.000000000 0.016545652 0.008954206 0.018490329
      c 0.005866247 0.000000000 0.013548963 0.008425469
      g 0.007368026 0.026508515 0.000000000 0.005961041
      t 0.004019258 0.004158852 0.004964872 0.000000000
      
      , , l = 5, f_(2/3)
      
                  a           c           g            t
      a 0.000000000 0.012211103 0.007131139 0.0003640589
      c 0.004836647 0.000000000 0.000000000 0.0020998409
      g 0.001799055 0.000786086 0.000000000 0.0042122015
      t 0.000000000 0.001341731 0.000000000 0.0000000000
      
      , , l = 6, f_(2/3)
      
                   a c           g            t
      a 0.0000000000 0 0.000000000 0.0005766099
      c 0.0000000000 0 0.000000000 0.0000000000
      g 0.0002785379 0 0.000000000 0.0008776639
      t 0.0000000000 0 0.003408134 0.0000000000
      
      , , l = 7, f_(2/3)
      
        a           c g            t
      a 0 0.000000000 0 0.0000000000
      c 0 0.000000000 0 0.0003825579
      g 0 0.003594163 0 0.0000000000
      t 0 0.000000000 0 0.0000000000
      
      , , l = 1, f_1
      
                a         c         g         t
      a 0.0000000 0.6918310 0.7564914 0.7608399
      c 0.7293402 0.0000000 0.6279291 0.8004334
      g 0.8144021 0.6605775 0.0000000 0.6484991
      t 0.7042885 0.7357449 0.8115108 0.0000000
      
      , , l = 2, f_1
      
                a         c         g         t
      a 0.0000000 0.2024268 0.2201402 0.1606913
      c 0.2134969 0.0000000 0.2572559 0.1613275
      g 0.1181600 0.2568767 0.0000000 0.2362740
      t 0.2277994 0.1529680 0.1510039 0.0000000
      
      , , l = 3, f_1
      
                 a          c           g           t
      a 0.00000000 0.09054333 0.019850805 0.069113203
      c 0.04359322 0.00000000 0.107419310 0.003876667
      g 0.05071007 0.07291147 0.000000000 0.102814853
      t 0.05458864 0.10402045 0.002962903 0.000000000
      
      , , l = 4, f_1
      
                  a           c            g           t
      a 0.000000000 0.009750781 0.0005751639 0.004537518
      c 0.008154595 0.000000000 0.0073956884 0.017324004
      g 0.013582403 0.006245772 0.0000000000 0.004148355
      t 0.013323461 0.004346613 0.0296089261 0.000000000
      
      , , l = 5, f_1
      
                   a            c           g           t
      a 0.0000000000 0.0054481428 0.002942435 0.003301072
      c 0.0054150756 0.0000000000 0.000000000 0.016952731
      g 0.0006765499 0.0007725014 0.000000000 0.004647107
      t 0.0000000000 0.0029199955 0.000000000 0.000000000
      
      , , l = 6, f_1
      
                  a c           g           t
      a 0.000000000 0 0.000000000 0.001517062
      c 0.000000000 0 0.000000000 0.000000000
      g 0.002468953 0 0.000000000 0.003616617
      t 0.000000000 0 0.004913457 0.000000000
      
      , , l = 7, f_1
      
        a           c g            t
      a 0 0.000000000 0 0.000000e+00
      c 0 0.000000000 0 8.573929e-05
      g 0 0.002616097 0 0.000000e+00
      t 0 0.000000000 0 0.000000e+00
      
      
      $emc
        [1] "g" "t" "a" "c" "a" "t" "c" "t" "g" "a" "g" "t" "a" "g" "a" "c" "t" "c"
       [19] "g" "c" "g" "a" "g" "t" "g" "c" "a" "t" "a" "c" "t" "g" "a" "t" "a" "t"
       [37] "a" "c" "g" "t" "g" "a" "g" "c" "g" "t" "g" "a" "g" "t" "g" "a" "c" "a"
       [55] "g" "a" "g" "a" "g" "a" "g" "t" "g" "a" "c" "t" "c" "t" "a" "g" "a" "t"
       [73] "g" "a" "t" "c" "g" "a" "t" "a" "t" "g" "c" "t" "c" "g" "t" "a" "g" "c"
       [91] "a" "g" "t" "c" "t" "c" "t" "a" "t" "a"
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $soj_times
        [1] 2 1 1 1 2 2 3 1 1 1 1 1 1 1 2 1 1 1 2 1 1 1 2 1 1 1 1 1 1 1 1 1 1 1 1 2 1
       [38] 1 1 2 1 1 1 3 1 2 1 1 3 1 2 1 1 1 1 1 3 2 1 2 1 1 2 1 1 1 5 1 3 2 1 2 2 1
       [75] 1 2 1 1 1 1 1 2 2 1 1 1 1 1 2 1 1 1 1 2 2 2 1 1 3 1
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $initial_dist
              a         c         g         t 
      0.2556471 0.2454159 0.2553813 0.2435557 
      
      $states
      a c g t 
      
      $s
      4 
      
      $degree
      3 
      
      $k_max
      7 
      
      $model_size
      7525 
      
      $f_is_drifting
      TRUE 
      
      $p_is_drifting
      TRUE 
      
      $Model
      Model_1 
      
      $estimation
      nonparametric 
      
      
      Class: dsmm_fit_nonparametric, dsmm

# fit_dsmm() non parametric estimation; p is drifting and f is not drifting

    Code
      obj_model_2
    Output
      
      
      
      $dist$p_drift
      
      , , p_0
      
                a         c         g         t
      a 0.0000000 0.2928374 0.3717104 0.3354522
      c 0.3023716 0.0000000 0.3962073 0.3014211
      g 0.3436550 0.3047510 0.0000000 0.3515940
      t 0.3325151 0.2558372 0.4116477 0.0000000
      
      , , p_(1/3)
      
                a         c         g         t
      a 0.0000000 0.3684005 0.3296269 0.3019726
      c 0.3520526 0.0000000 0.3391474 0.3088001
      g 0.3714217 0.3247288 0.0000000 0.3038496
      t 0.3554353 0.3402464 0.3043183 0.0000000
      
      , , p_(2/3)
      
                a         c         g         t
      a 0.0000000 0.3088205 0.3285419 0.3626376
      c 0.3434957 0.0000000 0.3389797 0.3175246
      g 0.3208303 0.3117509 0.0000000 0.3674188
      t 0.3407074 0.2749527 0.3843399 0.0000000
      
      , , p_1
      
                a         c         g         t
      a 0.0000000 0.3918856 0.3910772 0.2170372
      c 0.3454498 0.0000000 0.3041657 0.3503845
      g 0.3226336 0.3867389 0.0000000 0.2906275
      t 0.3444807 0.3937185 0.2618008 0.0000000
      
      
      
      
      $dist$f_notdrift
      
      , , l = 1
      
                a         c         g         t
      a 0.0000000 0.7423679 0.7346813 0.7881830
      c 0.7243360 0.0000000 0.7379101 0.7582481
      g 0.7458405 0.7074979 0.0000000 0.7466879
      t 0.7531994 0.7709089 0.7714362 0.0000000
      
      , , l = 2
      
                a         c         g         t
      a 0.0000000 0.1895786 0.2006419 0.1446604
      c 0.2056080 0.0000000 0.1833008 0.1735317
      g 0.1837347 0.2306185 0.0000000 0.1792066
      t 0.1857745 0.1688135 0.1739130 0.0000000
      
      , , l = 3
      
                 a          c          g          t
      a 0.00000000 0.04647201 0.05316384 0.04833413
      c 0.05109524 0.00000000 0.06516407 0.04365615
      g 0.04739087 0.04589149 0.00000000 0.06303146
      t 0.05322058 0.05416549 0.04035604 0.00000000
      
      , , l = 4
      
                  a           c           g           t
      a 0.000000000 0.013857071 0.004266722 0.010670319
      c 0.009224024 0.000000000 0.013625065 0.010290295
      g 0.017967253 0.010900086 0.000000000 0.005947355
      t 0.007805504 0.003693068 0.011799615 0.000000000
      
      , , l = 5
      
                  a           c           g           t
      a 0.000000000 0.007724423 0.007246288 0.005384749
      c 0.009736745 0.000000000 0.000000000 0.010818586
      g 0.002381249 0.002533386 0.000000000 0.002644020
      t 0.000000000 0.002419070 0.000000000 0.000000000
      
      , , l = 6
      
                  a c           g           t
      a 0.000000000 0 0.000000000 0.002767329
      c 0.000000000 0 0.000000000 0.000000000
      g 0.002685457 0 0.000000000 0.002482655
      t 0.000000000 0 0.002495176 0.000000000
      
      , , l = 7
      
        a           c g           t
      a 0 0.000000000 0 0.000000000
      c 0 0.000000000 0 0.003455158
      g 0 0.002558627 0 0.000000000
      t 0 0.000000000 0 0.000000000
      
      
      $emc
        [1] "g" "t" "a" "c" "a" "t" "c" "t" "g" "a" "g" "t" "a" "g" "a" "c" "t" "c"
       [19] "g" "c" "g" "a" "g" "t" "g" "c" "a" "t" "a" "c" "t" "g" "a" "t" "a" "t"
       [37] "a" "c" "g" "t" "g" "a" "g" "c" "g" "t" "g" "a" "g" "t" "g" "a" "c" "a"
       [55] "g" "a" "g" "a" "g" "a" "g" "t" "g" "a" "c" "t" "c" "t" "a" "g" "a" "t"
       [73] "g" "a" "t" "c" "g" "a" "t" "a" "t" "g" "c" "t" "c" "g" "t" "a" "g" "c"
       [91] "a" "g" "t" "c" "t" "c" "t" "a" "t" "a"
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $soj_times
        [1] 2 1 1 1 2 2 3 1 1 1 1 1 1 1 2 1 1 1 2 1 1 1 2 1 1 1 1 1 1 1 1 1 1 1 1 2 1
       [38] 1 1 2 1 1 1 3 1 2 1 1 3 1 2 1 1 1 1 1 3 2 1 2 1 1 2 1 1 1 5 1 3 2 1 2 2 1
       [75] 1 2 1 1 1 1 1 2 2 1 1 1 1 1 2 1 1 1 1 2 2 2 1 1 3 1
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $initial_dist
         a    c    g    t 
      0.25 0.25 0.25 0.25 
      
      $states
      a c g t 
      
      $s
      4 
      
      $degree
      3 
      
      $k_max
      7 
      
      $model_size
      7525 
      
      $f_is_drifting
      FALSE 
      
      $p_is_drifting
      TRUE 
      
      $Model
      Model_2 
      
      $estimation
      nonparametric 
      
      
      Class: dsmm_fit_nonparametric, dsmm

# fit_dsmm() non parametric estimation; p is not drifting and f is drifting

    Code
      obj_model_3
    Output
      
      
      
      $dist$p_notdrift
      
                a         c         g         t
      a 0.0000000 0.3404860 0.3552391 0.3042749
      c 0.3358424 0.0000000 0.3446250 0.3195326
      g 0.3396351 0.3319924 0.0000000 0.3283725
      t 0.3432846 0.3161887 0.3405267 0.0000000
      
      
      
      $dist$f_drift
      
      , , l = 1, f_0
      
                a         c         g         t
      a 0.0000000 0.7901328 0.6937341 0.9168894
      c 0.6063477 0.0000000 0.8197100 0.7144069
      g 0.6644908 0.7497707 0.0000000 0.7786443
      t 0.8231650 0.7519020 0.7267143 0.0000000
      
      , , l = 2, f_0
      
                a         c         g         t
      a 0.0000000 0.1795942 0.2045875 0.0590463
      c 0.3051466 0.0000000 0.1177530 0.1755653
      g 0.2487514 0.2350138 0.0000000 0.1477476
      t 0.1261540 0.2456668 0.2121029 0.0000000
      
      , , l = 3, f_0
      
                 a            c          g           t
      a 0.00000000 0.0064975233 0.08812030 0.001311742
      c 0.04843243 0.0000000000 0.04110996 0.072231442
      g 0.05294269 0.0013697112 0.00000000 0.068673117
      t 0.04671494 0.0005535745 0.04746970 0.000000000
      
      , , l = 4, f_0
      
                  a           c            g           t
      a 0.000000000 0.013001245 0.0004897316 0.002611603
      c 0.009695910 0.000000000 0.0214270548 0.002758149
      g 0.027243925 0.008015025 0.0000000000 0.002609832
      t 0.003966075 0.001826416 0.0131941395 0.000000000
      
      , , l = 5, f_0
      
                  a            c          g           t
      a 0.000000000 1.077420e-02 0.01306832 0.016106136
      c 0.030377356 0.000000e+00 0.00000000 0.021690629
      g 0.003303159 4.246079e-03 0.00000000 0.001283716
      t 0.000000000 5.116206e-05 0.00000000 0.000000000
      
      , , l = 6, f_0
      
                  a c            g           t
      a 0.000000000 0 0.0000000000 0.004034844
      c 0.000000000 0 0.0000000000 0.000000000
      g 0.003268051 0 0.0000000000 0.001041519
      t 0.000000000 0 0.0005189207 0.000000000
      
      , , l = 7, f_0
      
        a           c g          t
      a 0 0.000000000 0 0.00000000
      c 0 0.000000000 0 0.01334759
      g 0 0.001584681 0 0.00000000
      t 0 0.000000000 0 0.00000000
      
      , , l = 1, f_(1/3)
      
                a         c         g         t
      a 0.0000000 0.7612799 0.7518213 0.7066642
      c 0.7631653 0.0000000 0.7202603 0.7811277
      g 0.7555065 0.7043263 0.0000000 0.7554843
      t 0.7515527 0.7982977 0.7967939 0.0000000
      
      , , l = 2, f_(1/3)
      
                a         c         g         t
      a 0.0000000 0.1661836 0.1912965 0.1943938
      c 0.1592601 0.0000000 0.2001870 0.1621669
      g 0.1822475 0.2211870 0.0000000 0.1874509
      t 0.2031794 0.1445212 0.1636006 0.0000000
      
      , , l = 3, f_(1/3)
      
                 a          c          g          t
      a 0.00000000 0.05192429 0.04274673 0.07841241
      c 0.06339988 0.00000000 0.06937938 0.04213349
      g 0.03197207 0.06320993 0.00000000 0.04013910
      t 0.03558909 0.04872664 0.03444640 0.00000000
      
      , , l = 4, f_(1/3)
      
                  a           c           g          t
      a 0.000000000 0.016651651 0.008233620 0.01463932
      c 0.013144266 0.000000000 0.010173331 0.01157907
      g 0.022348467 0.004166118 0.000000000 0.01151347
      t 0.009678814 0.003963982 0.003224121 0.00000000
      
      , , l = 5, f_(1/3)
      
                  a           c           g            t
      a 0.000000000 0.003960512 0.005901915 0.0010016151
      c 0.001030513 0.000000000 0.000000000 0.0022112119
      g 0.003511931 0.004700674 0.000000000 0.0004058857
      t 0.000000000 0.004490487 0.000000000 0.0000000000
      
      , , l = 6, f_(1/3)
      
                  a c           g           t
      a 0.000000000 0 0.000000000 0.004888717
      c 0.000000000 0 0.000000000 0.000000000
      g 0.004413552 0 0.000000000 0.005006397
      t 0.000000000 0 0.001934993 0.000000000
      
      , , l = 7, f_(1/3)
      
        a           c g            t
      a 0 0.000000000 0 0.0000000000
      c 0 0.000000000 0 0.0007816748
      g 0 0.002410059 0 0.0000000000
      t 0 0.000000000 0 0.0000000000
      
      , , l = 1, f_(2/3)
      
                a         c         g         t
      a 0.0000000 0.7386446 0.7378505 0.7533718
      c 0.7833693 0.0000000 0.7586445 0.7310639
      g 0.7528406 0.7276847 0.0000000 0.7865006
      t 0.7360867 0.8050546 0.7719600 0.0000000
      
      , , l = 2, f_(2/3)
      
                a         c         g         t
      a 0.0000000 0.2106506 0.1823445 0.1728485
      c 0.1575551 0.0000000 0.1766604 0.1961211
      g 0.1817574 0.2035716 0.0000000 0.1573527
      t 0.1833138 0.1500540 0.1567797 0.0000000
      
      , , l = 3, f_(2/3)
      
                 a          c          g          t
      a 0.00000000 0.02194799 0.06371970 0.05434872
      c 0.04837279 0.00000000 0.05114615 0.06190707
      g 0.05595639 0.03785489 0.00000000 0.04509583
      t 0.07658024 0.03939081 0.06288726 0.00000000
      
      , , l = 4, f_(2/3)
      
                  a           c           g           t
      a 0.000000000 0.016545652 0.008954206 0.018490329
      c 0.005866247 0.000000000 0.013548963 0.008425469
      g 0.007368026 0.026508515 0.000000000 0.005961041
      t 0.004019258 0.004158852 0.004964872 0.000000000
      
      , , l = 5, f_(2/3)
      
                  a           c           g            t
      a 0.000000000 0.012211103 0.007131139 0.0003640589
      c 0.004836647 0.000000000 0.000000000 0.0020998409
      g 0.001799055 0.000786086 0.000000000 0.0042122015
      t 0.000000000 0.001341731 0.000000000 0.0000000000
      
      , , l = 6, f_(2/3)
      
                   a c           g            t
      a 0.0000000000 0 0.000000000 0.0005766099
      c 0.0000000000 0 0.000000000 0.0000000000
      g 0.0002785379 0 0.000000000 0.0008776639
      t 0.0000000000 0 0.003408134 0.0000000000
      
      , , l = 7, f_(2/3)
      
        a           c g            t
      a 0 0.000000000 0 0.0000000000
      c 0 0.000000000 0 0.0003825579
      g 0 0.003594163 0 0.0000000000
      t 0 0.000000000 0 0.0000000000
      
      , , l = 1, f_1
      
                a         c         g         t
      a 0.0000000 0.6918310 0.7564914 0.7608399
      c 0.7293402 0.0000000 0.6279291 0.8004334
      g 0.8144021 0.6605775 0.0000000 0.6484991
      t 0.7042885 0.7357449 0.8115108 0.0000000
      
      , , l = 2, f_1
      
                a         c         g         t
      a 0.0000000 0.2024268 0.2201402 0.1606913
      c 0.2134969 0.0000000 0.2572559 0.1613275
      g 0.1181600 0.2568767 0.0000000 0.2362740
      t 0.2277994 0.1529680 0.1510039 0.0000000
      
      , , l = 3, f_1
      
                 a          c           g           t
      a 0.00000000 0.09054333 0.019850805 0.069113203
      c 0.04359322 0.00000000 0.107419310 0.003876667
      g 0.05071007 0.07291147 0.000000000 0.102814853
      t 0.05458864 0.10402045 0.002962903 0.000000000
      
      , , l = 4, f_1
      
                  a           c            g           t
      a 0.000000000 0.009750781 0.0005751639 0.004537518
      c 0.008154595 0.000000000 0.0073956884 0.017324004
      g 0.013582403 0.006245772 0.0000000000 0.004148355
      t 0.013323461 0.004346613 0.0296089261 0.000000000
      
      , , l = 5, f_1
      
                   a            c           g           t
      a 0.0000000000 0.0054481428 0.002942435 0.003301072
      c 0.0054150756 0.0000000000 0.000000000 0.016952731
      g 0.0006765499 0.0007725014 0.000000000 0.004647107
      t 0.0000000000 0.0029199955 0.000000000 0.000000000
      
      , , l = 6, f_1
      
                  a c           g           t
      a 0.000000000 0 0.000000000 0.001517062
      c 0.000000000 0 0.000000000 0.000000000
      g 0.002468953 0 0.000000000 0.003616617
      t 0.000000000 0 0.004913457 0.000000000
      
      , , l = 7, f_1
      
        a           c g            t
      a 0 0.000000000 0 0.000000e+00
      c 0 0.000000000 0 8.573929e-05
      g 0 0.002616097 0 0.000000e+00
      t 0 0.000000000 0 0.000000e+00
      
      
      $emc
        [1] "g" "t" "a" "c" "a" "t" "c" "t" "g" "a" "g" "t" "a" "g" "a" "c" "t" "c"
       [19] "g" "c" "g" "a" "g" "t" "g" "c" "a" "t" "a" "c" "t" "g" "a" "t" "a" "t"
       [37] "a" "c" "g" "t" "g" "a" "g" "c" "g" "t" "g" "a" "g" "t" "g" "a" "c" "a"
       [55] "g" "a" "g" "a" "g" "a" "g" "t" "g" "a" "c" "t" "c" "t" "a" "g" "a" "t"
       [73] "g" "a" "t" "c" "g" "a" "t" "a" "t" "g" "c" "t" "c" "g" "t" "a" "g" "c"
       [91] "a" "g" "t" "c" "t" "c" "t" "a" "t" "a"
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $soj_times
        [1] 2 1 1 1 2 2 3 1 1 1 1 1 1 1 2 1 1 1 2 1 1 1 2 1 1 1 1 1 1 1 1 1 1 1 1 2 1
       [38] 1 1 2 1 1 1 3 1 2 1 1 3 1 2 1 1 1 1 1 3 2 1 2 1 1 2 1 1 1 5 1 3 2 1 2 2 1
       [75] 1 2 1 1 1 1 1 2 2 1 1 1 1 1 2 1 1 1 1 2 2 2 1 1 3 1
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $initial_dist
         a    c    g    t 
      0.25 0.25 0.25 0.25 
      
      $states
      a c g t 
      
      $s
      4 
      
      $degree
      3 
      
      $k_max
      7 
      
      $model_size
      7525 
      
      $f_is_drifting
      TRUE 
      
      $p_is_drifting
      FALSE 
      
      $Model
      Model_3 
      
      $estimation
      nonparametric 
      
      
      Class: dsmm_fit_nonparametric, dsmm

# fit_dsmm() parametric estimation; p and f are drifting

    Code
      obj_fit_parametric_1
    Output
      
      
      
      $dist$p_drift
      
      , , p_0
      
                a         c         g         t
      a 0.0000000 0.2928374 0.3717104 0.3354522
      c 0.3023716 0.0000000 0.3962073 0.3014211
      g 0.3436550 0.3047510 0.0000000 0.3515940
      t 0.3325151 0.2558372 0.4116477 0.0000000
      
      , , p_(1/3)
      
                a         c         g         t
      a 0.0000000 0.3684005 0.3296269 0.3019726
      c 0.3520526 0.0000000 0.3391474 0.3088001
      g 0.3714217 0.3247288 0.0000000 0.3038496
      t 0.3554353 0.3402464 0.3043183 0.0000000
      
      , , p_(2/3)
      
                a         c         g         t
      a 0.0000000 0.3088205 0.3285419 0.3626376
      c 0.3434957 0.0000000 0.3389797 0.3175246
      g 0.3208303 0.3117509 0.0000000 0.3674188
      t 0.3407074 0.2749527 0.3843399 0.0000000
      
      , , p_1
      
                a         c         g         t
      a 0.0000000 0.3918856 0.3910772 0.2170372
      c 0.3454498 0.0000000 0.3041657 0.3503845
      g 0.3226336 0.3867389 0.0000000 0.2906275
      t 0.3444807 0.3937185 0.2618008 0.0000000
      
      
      
      
      $dist$f_drift_parametric
      
      , , 1
      
           [,1]   [,2]   [,3]   [,4]  
      [1,] NA     "unif" "geom" "pois"
      [2,] "pois" NA     "pois" "geom"
      [3,] "geom" "pois" NA     "geom"
      [4,] "geom" "geom" "pois" NA    
      
      , , 2
      
           [,1]   [,2]   [,3]   [,4]  
      [1,] NA     "unif" "geom" "pois"
      [2,] "pois" NA     "pois" "geom"
      [3,] "geom" "pois" NA     "geom"
      [4,] "geom" "geom" "pois" NA    
      
      , , 3
      
           [,1]   [,2]   [,3]   [,4]  
      [1,] NA     "unif" "geom" "pois"
      [2,] "pois" NA     "pois" "geom"
      [3,] "geom" "pois" NA     "geom"
      [4,] "geom" "geom" "pois" NA    
      
      , , 4
      
           [,1]   [,2]   [,3]   [,4]  
      [1,] NA     "unif" "geom" "pois"
      [2,] "pois" NA     "pois" "geom"
      [3,] "geom" "pois" NA     "geom"
      [4,] "geom" "geom" "pois" NA    
      
      
      
      
      $dist$f_drift_parameters
      
      , , 1, fpars_0
      
                a         c         g         t
      a        NA 3.0000000 0.6970727 0.1541034
      c 0.5526086        NA 0.2642541 0.6688289
      g 0.6821648 0.2882907        NA 0.7673032
      t 0.8120297 0.7984301 0.3492194        NA
      
      , , 2, fpars_0
      
         a  c  g  t
      a NA NA NA NA
      c NA NA NA NA
      g NA NA NA NA
      t NA NA NA NA
      
      , , 1, fpars_(1/3)
      
                a         c         g         t
      a        NA 5.0000000 0.7546609 0.4235866
      c 0.3296147        NA 0.3694657 0.7723762
      g 0.7410962 0.3933682        NA 0.7524879
      t 0.7672277 0.7862696 0.2518407        NA
      
      , , 2, fpars_(1/3)
      
         a  c  g  t
      a NA NA NA NA
      c NA NA NA NA
      g NA NA NA NA
      t NA NA NA NA
      
      , , 1, fpars_(2/3)
      
                a         c         g         t
      a        NA 3.0000000 0.7325090 0.3413562
      c 0.2912460        NA 0.3195996 0.7375140
      g 0.7550799 0.3835163        NA 0.7772033
      t 0.7415471 0.8021310 0.3144896        NA
      
      , , 2, fpars_(2/3)
      
         a  c  g  t
      a NA NA NA NA
      c NA NA NA NA
      g NA NA NA NA
      t NA NA NA NA
      
      , , 1, fpars_1
      
                a         c         g         t
      a        NA 3.0000000 0.7853381 0.3333198
      c 0.3468074        NA 0.4942816 0.7755676
      g 0.7840811 0.4402235        NA 0.6706817
      t 0.7262443 0.7216419 0.2703238        NA
      
      , , 2, fpars_1
      
         a  c  g  t
      a NA NA NA NA
      c NA NA NA NA
      g NA NA NA NA
      t NA NA NA NA
      
      
      $emc
        [1] "g" "t" "a" "c" "a" "t" "c" "t" "g" "a" "g" "t" "a" "g" "a" "c" "t" "c"
       [19] "g" "c" "g" "a" "g" "t" "g" "c" "a" "t" "a" "c" "t" "g" "a" "t" "a" "t"
       [37] "a" "c" "g" "t" "g" "a" "g" "c" "g" "t" "g" "a" "g" "t" "g" "a" "c" "a"
       [55] "g" "a" "g" "a" "g" "a" "g" "t" "g" "a" "c" "t" "c" "t" "a" "g" "a" "t"
       [73] "g" "a" "t" "c" "g" "a" "t" "a" "t" "g" "c" "t" "c" "g" "t" "a" "g" "c"
       [91] "a" "g" "t" "c" "t" "c" "t" "a" "t" "a"
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $soj_times
        [1] 2 1 1 1 2 2 3 1 1 1 1 1 1 1 2 1 1 1 2 1 1 1 2 1 1 1 1 1 1 1 1 1 1 1 1 2 1
       [38] 1 1 2 1 1 1 3 1 2 1 1 3 1 2 1 1 1 1 1 3 2 1 2 1 1 2 1 1 1 5 1 3 2 1 2 2 1
       [75] 1 2 1 1 1 1 1 2 2 1 1 1 1 1 2 1 1 1 1 2 2 2 1 1 3 1
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $initial_dist
         a    c    g    t 
      0.25 0.25 0.25 0.25 
      
      $states
      a c g t 
      
      $s
      4 
      
      $degree
      3 
      
      $k_max
      7 
      
      $model_size
      7525 
      
      $f_is_drifting
      TRUE 
      
      $p_is_drifting
      TRUE 
      
      $Model
      Model_1 
      
      $estimation
      parametric 
      
      
      Class: dsmm_fit_parametric, dsmm

# fit_dsmm() parametric estimation; p is drifting, f is not drifting

    Code
      obj_fit_parametric_2
    Output
      
      
      
      $dist$p_drift
      
      , , p_0
      
                a         c         g         t
      a 0.0000000 0.2928374 0.3717104 0.3354522
      c 0.3023716 0.0000000 0.3962073 0.3014211
      g 0.3436550 0.3047510 0.0000000 0.3515940
      t 0.3325151 0.2558372 0.4116477 0.0000000
      
      , , p_(1/3)
      
                a         c         g         t
      a 0.0000000 0.3684005 0.3296269 0.3019726
      c 0.3520526 0.0000000 0.3391474 0.3088001
      g 0.3714217 0.3247288 0.0000000 0.3038496
      t 0.3554353 0.3402464 0.3043183 0.0000000
      
      , , p_(2/3)
      
                a         c         g         t
      a 0.0000000 0.3088205 0.3285419 0.3626376
      c 0.3434957 0.0000000 0.3389797 0.3175246
      g 0.3208303 0.3117509 0.0000000 0.3674188
      t 0.3407074 0.2749527 0.3843399 0.0000000
      
      , , p_1
      
                a         c         g         t
      a 0.0000000 0.3918856 0.3910772 0.2170372
      c 0.3454498 0.0000000 0.3041657 0.3503845
      g 0.3226336 0.3867389 0.0000000 0.2906275
      t 0.3444807 0.3937185 0.2618008 0.0000000
      
      
      
      
      $dist$f_notdrift_parametric
      
           [,1]   [,2]   [,3]   [,4]  
      [1,] NA     "unif" "geom" "pois"
      [2,] "pois" NA     "pois" "geom"
      [3,] "geom" "pois" NA     "geom"
      [4,] "geom" "geom" "pois" NA    
      
      
      
      $dist$f_notdrift_parameters
      
      , , 1
      
                a         c         g         t
      a        NA 5.0000000 0.7414246 0.3087153
      c 0.3744175        NA 0.3545041 0.7376153
      g 0.7378057 0.3805870        NA 0.7428863
      t 0.7600909 0.7704754 0.3024998        NA
      
      , , 2
      
         a  c  g  t
      a NA NA NA NA
      c NA NA NA NA
      g NA NA NA NA
      t NA NA NA NA
      
      
      $emc
        [1] "g" "t" "a" "c" "a" "t" "c" "t" "g" "a" "g" "t" "a" "g" "a" "c" "t" "c"
       [19] "g" "c" "g" "a" "g" "t" "g" "c" "a" "t" "a" "c" "t" "g" "a" "t" "a" "t"
       [37] "a" "c" "g" "t" "g" "a" "g" "c" "g" "t" "g" "a" "g" "t" "g" "a" "c" "a"
       [55] "g" "a" "g" "a" "g" "a" "g" "t" "g" "a" "c" "t" "c" "t" "a" "g" "a" "t"
       [73] "g" "a" "t" "c" "g" "a" "t" "a" "t" "g" "c" "t" "c" "g" "t" "a" "g" "c"
       [91] "a" "g" "t" "c" "t" "c" "t" "a" "t" "a"
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $soj_times
        [1] 2 1 1 1 2 2 3 1 1 1 1 1 1 1 2 1 1 1 2 1 1 1 2 1 1 1 1 1 1 1 1 1 1 1 1 2 1
       [38] 1 1 2 1 1 1 3 1 2 1 1 3 1 2 1 1 1 1 1 3 2 1 2 1 1 2 1 1 1 5 1 3 2 1 2 2 1
       [75] 1 2 1 1 1 1 1 2 2 1 1 1 1 1 2 1 1 1 1 2 2 2 1 1 3 1
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $initial_dist
         a    c    g    t 
      0.25 0.25 0.25 0.25 
      
      $states
      a c g t 
      
      $s
      4 
      
      $degree
      3 
      
      $k_max
      7 
      
      $model_size
      7525 
      
      $f_is_drifting
      FALSE 
      
      $p_is_drifting
      TRUE 
      
      $Model
      Model_2 
      
      $estimation
      parametric 
      
      
      Class: dsmm_fit_parametric, dsmm

# fit_dsmm() parametric estimation; p is not drifting, f is drifting

    Code
      obj_fit_parametric_3
    Output
      
      
      
      $dist$p_notdrift
      
                a         c         g         t
      a 0.0000000 0.3404860 0.3552391 0.3042749
      c 0.3358424 0.0000000 0.3446250 0.3195326
      g 0.3396351 0.3319924 0.0000000 0.3283725
      t 0.3432846 0.3161887 0.3405267 0.0000000
      
      
      
      $dist$f_drift_parametric
      
      , , 1
      
           [,1]   [,2]   [,3]   [,4]  
      [1,] NA     "unif" "geom" "pois"
      [2,] "pois" NA     "pois" "geom"
      [3,] "geom" "pois" NA     "geom"
      [4,] "geom" "geom" "pois" NA    
      
      , , 2
      
           [,1]   [,2]   [,3]   [,4]  
      [1,] NA     "unif" "geom" "pois"
      [2,] "pois" NA     "pois" "geom"
      [3,] "geom" "pois" NA     "geom"
      [4,] "geom" "geom" "pois" NA    
      
      , , 3
      
           [,1]   [,2]   [,3]   [,4]  
      [1,] NA     "unif" "geom" "pois"
      [2,] "pois" NA     "pois" "geom"
      [3,] "geom" "pois" NA     "geom"
      [4,] "geom" "geom" "pois" NA    
      
      , , 4
      
           [,1]   [,2]   [,3]   [,4]  
      [1,] NA     "unif" "geom" "pois"
      [2,] "pois" NA     "pois" "geom"
      [3,] "geom" "pois" NA     "geom"
      [4,] "geom" "geom" "pois" NA    
      
      
      
      
      $dist$f_drift_parameters
      
      , , 1, fpars_0
      
                a         c         g         t
      a        NA 3.0000000 0.6970727 0.1541034
      c 0.5526086        NA 0.2642541 0.6688289
      g 0.6821648 0.2882907        NA 0.7673032
      t 0.8120297 0.7984301 0.3492194        NA
      
      , , 2, fpars_0
      
         a  c  g  t
      a NA NA NA NA
      c NA NA NA NA
      g NA NA NA NA
      t NA NA NA NA
      
      , , 1, fpars_(1/3)
      
                a         c         g         t
      a        NA 5.0000000 0.7546609 0.4235866
      c 0.3296147        NA 0.3694657 0.7723762
      g 0.7410962 0.3933682        NA 0.7524879
      t 0.7672277 0.7862696 0.2518407        NA
      
      , , 2, fpars_(1/3)
      
         a  c  g  t
      a NA NA NA NA
      c NA NA NA NA
      g NA NA NA NA
      t NA NA NA NA
      
      , , 1, fpars_(2/3)
      
                a         c         g         t
      a        NA 3.0000000 0.7325090 0.3413562
      c 0.2912460        NA 0.3195996 0.7375140
      g 0.7550799 0.3835163        NA 0.7772033
      t 0.7415471 0.8021310 0.3144896        NA
      
      , , 2, fpars_(2/3)
      
         a  c  g  t
      a NA NA NA NA
      c NA NA NA NA
      g NA NA NA NA
      t NA NA NA NA
      
      , , 1, fpars_1
      
                a         c         g         t
      a        NA 3.0000000 0.7853381 0.3333198
      c 0.3468074        NA 0.4942816 0.7755676
      g 0.7840811 0.4402235        NA 0.6706817
      t 0.7262443 0.7216419 0.2703238        NA
      
      , , 2, fpars_1
      
         a  c  g  t
      a NA NA NA NA
      c NA NA NA NA
      g NA NA NA NA
      t NA NA NA NA
      
      
      $emc
        [1] "g" "t" "a" "c" "a" "t" "c" "t" "g" "a" "g" "t" "a" "g" "a" "c" "t" "c"
       [19] "g" "c" "g" "a" "g" "t" "g" "c" "a" "t" "a" "c" "t" "g" "a" "t" "a" "t"
       [37] "a" "c" "g" "t" "g" "a" "g" "c" "g" "t" "g" "a" "g" "t" "g" "a" "c" "a"
       [55] "g" "a" "g" "a" "g" "a" "g" "t" "g" "a" "c" "t" "c" "t" "a" "g" "a" "t"
       [73] "g" "a" "t" "c" "g" "a" "t" "a" "t" "g" "c" "t" "c" "g" "t" "a" "g" "c"
       [91] "a" "g" "t" "c" "t" "c" "t" "a" "t" "a"
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $soj_times
        [1] 2 1 1 1 2 2 3 1 1 1 1 1 1 1 2 1 1 1 2 1 1 1 2 1 1 1 1 1 1 1 1 1 1 1 1 2 1
       [38] 1 1 2 1 1 1 3 1 2 1 1 3 1 2 1 1 1 1 1 3 2 1 2 1 1 2 1 1 1 5 1 3 2 1 2 2 1
       [75] 1 2 1 1 1 1 1 2 2 1 1 1 1 1 2 1 1 1 1 2 2 2 1 1 3 1
       ... [ output truncated at 100 values -- ommited  7426  entries ]
      
      $initial_dist
         a    c    g    t 
      0.25 0.25 0.25 0.25 
      
      $states
      a c g t 
      
      $s
      4 
      
      $degree
      3 
      
      $k_max
      7 
      
      $model_size
      7525 
      
      $f_is_drifting
      TRUE 
      
      $p_is_drifting
      FALSE 
      
      $Model
      Model_3 
      
      $estimation
      parametric 
      
      
      Class: dsmm_fit_parametric, dsmm

