% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsdots.R
\name{dsdots}
\alias{dsdots}
\title{Adds a visualization of the system using dots}
\usage{
dsdots(col = "black", image = "", iters = 1, discretize = NULL,
  crop = TRUE, size = 0.37, behind = TRUE, ...)
}
\arguments{
\item{col}{A string specifying the color of the initial discretized points.}

\item{image}{Sets the color of the final image of the discretized points. See details.}

\item{iters}{Determines the number of iterations of the function when making a color gradient.
Use \code{col = color1, image = color2, iters = n} to create a gradient of colors between
color1 and color2. See details for more information.}

\item{discretize}{Overrides the discretization parameter defined in the range.}

\item{crop}{If \code{crop==TRUE}, remove points found outside of the range
from being rendered and iterated upon.}

\item{size}{Determines the display size of each dot.}

\item{behind}{Sets the dots as a background object for layering purposes.}

\item{...}{Extra graphical parameters}
}
\description{
The visualization displays a uniform array of points and their images under the function defined
by the model as dots.  Multiple
iterations of the function may be visualized.
In order to use this visualization, a discretization parameter must be provided in either the
range or to the \code{dsdots} object.
}
\details{
The \code{col} parameter defines the color of the initial, discretized, points.
There are three modes of operation.
If the \code{image} parameter
parameter is a single color, and \code{iters} is not set, then the image of each point is displayed as a
dot of color \code{image}.

Alternately, \code{image} can be set as a vector of colors (for example: \code{image =
c("red", "NA", "green")}). In this case the function is applied iteratively to the points a
number of times equal to the length of the vector. The initial points are displayed using
\code{col}. Each iteration is displayed by the
corresponding color. \code{"NA"} may be used to not display that iteration.
to specify the number of iterations of the function to apply.

Finally, if iters is set to a numeric value greater than 1, a color gradient is used to display
iterations. In this case both
\code{col} and \code{image} should be single colors. The function is applied \code{iters} time,
with each iteration being colored along the gradient from \code{col} to \code{image}.

In most cases, rather than specifying \code{col} and \code{image} separately, they may be
combined into a single vector.
}
\examples{
library(dsmodels)

fun <- function(X,Y) {
  list(
    X/exp(Y),
    Y/exp(X)
  )
}

model <- dsmodel(fun, title = "View of the Discretized Field")
range <- dsrange(-2:2,-2:2, discretize = 0.09)

# To view the discretized field, simply add dsdots() to your model
model + range + dsdots()

# To view a gradient with a certain amount of iterations,
# specify the image and the amount of iterations in the image
# and iters parameters, respectively.
dsmodel(fun, title = "Gradient of Iterations from Blue to Red") +
   dsrange(-2:2,-2:2, discretize = 0.09) +
   dsdots(col = "blue", image = "red", iters = 3)

# Set color to "NA" if you wish for the specified iteration to not
# appear in the image
dsmodel(fun, title = "Display Only the Third Iteration") +
   dsrange(-2:2,-2:2, discretize = 0.09) +
   dsdots(col = "NA", image = c("NA","blue"), size = 1)
}
\seealso{
\code{\link{dsarrows}}

\code{\link{dspoint}}
}
