% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.transects.R
\name{write.transects}
\alias{write.transects}
\title{Writes transects to file}
\usage{
write.transects(object, dsn)
}
\arguments{
\item{object}{and object inheriting from class Transect}

\item{dsn}{the data source name, for this simple function this is
a pathway and filename with a '.shp' extension.}
}
\value{
invisibly the Transect object
}
\description{
This function will write the geographic information inside
an object inheriting from class Transect to file. Currently the only
options is to write to shapefile. It is basically a simple wrapper
 around the sf::st_write function. The sf::wt_write function can be
 used directly on the samplers slot of the Transect object if more
  options are required.
}
\examples{
# Make the default design in the default study area
design <- make.design()
transects <- generate.transects(design)
write.transects(transects, dsn = paste0(tempdir(), "/", "transects.shp"))
}
\author{
Laura Marshall
}
