% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reduction.R
\name{reduction}
\alias{reduction}
\alias{aplRDV}
\title{Summary of a vector for any operator.}
\usage{
reduction(x, f)
}
\arguments{
\item{x}{A vector of numbers or a character string.}

\item{f}{The operator. Must be compatible with the type of input vector (numeric or character)}
}
\value{
The result of applying the chosen operator to all the elements of the vector is an object of length 1.
}
\description{
This utility function is used to obtain a summary of a vector of data for many operators. The function is taken from the project APL in R (\url{https://rpubs.com/deleeuw/158476}).
}
\examples{
 reduction(c(1,2,3,4), f = "-")
 reduction(c(1,0,1,1,0), f = "|")
 reduction(c("a", "b", "c"), f = "paste")
 
}
\references{
\itemize{
\item Jan de Leeuw and Masanao Yajima (March 07, 2016) \emph{APL in R (Version 009)}, Source code. \url{https://rpubs.com/deleeuw/158476}
\item G. Helzer. (1989): \emph{An Encyclopedia of APL}, second edition, I-APL LTD, St. Albans, G.B.
\item  L. Gilman and A. J. Rose.(1974): \emph{APL an Interactive Approach}, Second Edition, John Wiley, New-York.
 }
}
\author{
Claude Boivin, Stat.ASSQ.
}
