% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dDTGIW.R
\name{dDTGIW}
\alias{dDTGIW}
\title{The probability mass function (PMF) for Discrete Transmuted Generalized Inverse Weibull (DTGIW) distribution.}
\usage{
dDTGIW(x, alpha, beta, lambda, theta, log = FALSE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{alpha}{shape parameter#1.}

\item{beta}{scale parameter.}

\item{lambda}{shape pameter#2.}

\item{theta}{the transmuted parameter.}

\item{log}{logical(TRUE or FALSE); if log=FALSE, then return the PMF; if log=TRUE, then return the natural logarithms of the PMF.}
}
\value{
the PMF of DTGIW distribution
}
\description{
This function calculated the PMF of the DTGIW distribution.
}
\details{
The PMF of the DTGIW distribution is shown in Theorem 1 based on the research paper in references.
}
\examples{
x <- c(0:10)
dDTGIW(x,3.45,0.7,1.05,0)
}
\references{
Atchanut Rattanalertnusorn and Sirinapa Aryuyuen (2021).
The zero-truncated discrete transmuted generalized inverse Weibull distribution and its applications,
Songklanakarin Journal of Science and Technology (SJST), Volume 43 No.4 (July - August 2021), pp. 1140 - 1151. DOI: 10.14456/sjst-psu.2021.149
}
