% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl-dt.r
\name{tbl_dt}
\alias{.datatable.aware}
\alias{tbl_dt}
\title{Create a data table tbl.}
\usage{
tbl_dt(data, copy = TRUE)
}
\arguments{
\item{data}{a data table}

\item{copy}{If the input is a data.table, copy it?}
}
\description{
A data table tbl wraps a local data table.
}
\examples{
ds <- tbl_dt(mtcars)
ds
data.table::as.data.table(ds)

library(dplyr, warn.conflicts = FALSE)
if (require("nycflights13")) {
flights2 <- tbl_dt(flights)
flights2 \%>\% filter(month == 1, day == 1, dest == "DFW")
flights2 \%>\% select(year:day)
flights2 \%>\% rename(Year = year)
flights2 \%>\%
  summarise(
    delay = mean(arr_delay, na.rm = TRUE),
    n = length(arr_delay)
  )
flights2 \%>\%
  mutate(gained = arr_delay - dep_delay) \%>\%
  select(ends_with("delay"), gained)
flights2 \%>\%
  arrange(dest, desc(arr_delay))

by_dest <- group_by(flights2, dest)

filter(by_dest, arr_delay == max(arr_delay, na.rm = TRUE))
summarise(by_dest, arr = mean(arr_delay, na.rm = TRUE))

# Normalise arrival and departure delays by airport
by_dest \%>\%
  mutate(arr_z = scale(arr_delay), dep_z = scale(dep_delay)) \%>\%
  select(starts_with("arr"), starts_with("dep"))

arrange(by_dest, desc(arr_delay))
select(by_dest, -(day:tailnum))
rename(by_dest, Year = year)

# All manip functions preserve grouping structure, except for summarise
# which removes a grouping level
by_day <- group_by(flights2, year, month, day)
by_month <- summarise(by_day, delayed = sum(arr_delay > 0, na.rm = TRUE))
by_month
summarise(by_month, delayed = sum(delayed))

# You can also manually ungroup:
ungroup(by_day)
}
}

