% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class-dtwSat.R
\docType{methods}
\name{getMatches}
\alias{getMatches}
\title{Get matching points from dtwSat object}
\usage{
getMatches(object)
}
\arguments{
\item{object}{A \link[dtwSat]{dtwSat-class} object}
}
\value{
An object of class \code{\link[base]{list}} whose
 elements have the matching points for each alignment between
 the query and the template time series.
 Each element has two vectors:
      \cr\code{index1}: matching points of the query, and
      \cr\code{index2}: matching points of the template
}
\description{
This function retrieves the matching points
for each alignment between the \code{query} and the \code{template}
}
\examples{
names(query.list)
alig = dtwSat(query.list[["Soybean"]], template)
getMatches(alig)
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{dtwSat}}, \code{\link[dtwSat]{twdtw}}
}

