% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAccuracy.R
\name{plotAccuracy}
\alias{plotAccuracy}
\title{Plotting accuracy assessment}
\usage{
plotAccuracy(x, perc = TRUE, conf.int = 0.95, time.labels = NULL,
  category.name = NULL, category.type = NULL)
}
\arguments{
\item{x}{An object of class \code{\link[dtwSat]{twdtwAssessment}} or 
\code{\link[dtwSat]{twdtwCrossValidation}}.}

\item{perc}{if TRUE shows the results in percent of area. Otherwise shows the 
area in the map units or km2 for no project raster. Default is TRUE.}

\item{conf.int}{confidence level (0-1) for interval estimation of the population mean.
For details see \code{\link[Hmisc]{smean.cl.normal}}. Used if \code{x} is 
\code{\link[dtwSat]{twdtwCrossValidation}}.}

\item{time.labels}{a character or numeric for the time periods or NULL to 
aggregate all classified periods in the same plot. Default is NULL. Used 
if \code{x} is \code{\link[dtwSat]{twdtwAssessment}}.}

\item{category.name}{a character vector defining the class names. If NULL
the class names in the object \code{x} are used. Default is NULL.}

\item{category.type}{a character defining the categories type "numeric" 
or "letter", if NULL the class names are used. Default is NULL.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Method for plotting accuracy assessment results.
}
\examples{
\dontrun{

# See ?twdtwAssess and ?twdtwCrosValidate

plotAccuracy(x)

plotAccuracy(x, category.type="letter")

}

}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwAssessment}} and \code{\link[dtwSat]{twdtwAssess}}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
