% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdtw.R
\name{sdtw}
\alias{sdtw}
\title{Soft-DTW distance}
\usage{
sdtw(x, y, gamma = 0.01, ..., cm = NULL, error.check = TRUE)
}
\arguments{
\item{x, y}{Time series. Multivariate series must have time spanning the rows and variables
spanning the columns.}

\item{gamma}{Positive regularization parameter, with lower values resulting in less smoothing.}

\item{...}{Currently ignored.}

\item{cm}{Optionally, a matrix to use for the calculations. It should have \code{NROW(x)+1} rows and
\code{NROW(y)+1} columns. Used internally for memory optimization. If provided, it \strong{will} be
modified \emph{in place} by \code{C} code, except in the parallel version in \code{\link[proxy:dist]{proxy::dist()}} which
ignores it for thread-safe reasons.}

\item{error.check}{Logical indicating whether the function should try to detect inconsistencies
and give more informative errors messages. Also used internally to avoid repeating checks.}
}
\value{
The Soft DTW distance.
}
\description{
Soft-DTW distance measure as proposed in Cuturi and Blondel (2017).
}
\details{
Unlike other distances, soft-DTW can return negative values, and \code{sdtw(x, x)} is not always equal
to zero. Like DTW, soft-DTW does not follow the triangle inequality, but it is always symmetric.
}
\section{Proxy version}{


  The version registered with \code{\link[proxy]{dist}} is custom (\code{loop = FALSE} in
  \code{\link[proxy]{pr_DB}}). The custom function handles parallelization directly (with
  \code{\link[foreach]{foreach}}).



  It also includes symmetric optimizations to calculate only half a distance matrix when
  appropriate. Only one list of series should be provided. If you want to avoid this
  optimization, call \code{\link[proxy]{dist}} by giving the same list of series in both \code{x}
  and \code{y}.
}

\references{
Cuturi, M., & Blondel, M. (2017). Soft-DTW: a Differentiable Loss Function for Time-Series. arXiv
preprint arXiv:1703.01541.
}
