% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trig.R
\docType{methods}
\name{Trig}
\alias{Trig}
\alias{cos,dual-method}
\alias{sin,dual-method}
\alias{tan,dual-method}
\alias{acos,dual-method}
\alias{arccos,dual-method}
\alias{asin,dual-method}
\alias{arcsin,dual-method}
\alias{atan,dual-method}
\alias{arctan,dual-method}
\alias{atan2,ANY,dual-method}
\alias{atan2,dual,ANY-method}
\alias{atan2,dual,dual-method}
\alias{cospi,dual-method}
\alias{sinpi,dual-method}
\alias{tanpi,dual-method}
\alias{atan2,dual,numeric-method}
\alias{atan2,numeric,dual-method}
\title{Trigonometric Functions}
\usage{
\S4method{cos}{dual}(x)

\S4method{sin}{dual}(x)

\S4method{tan}{dual}(x)

\S4method{acos}{dual}(x)

\S4method{asin}{dual}(x)

\S4method{atan}{dual}(x)

\S4method{atan2}{dual,numeric}(y, x)

\S4method{atan2}{numeric,dual}(y, x)

\S4method{atan2}{dual,dual}(y, x)

\S4method{cospi}{dual}(x)

\S4method{sinpi}{dual}(x)

\S4method{tanpi}{dual}(x)
}
\arguments{
\item{x}{dual object or numeric value.}

\item{y}{dual object or numeric value.}
}
\value{
A dual object containing the transformed values according to the chosen function.
}
\description{
These functions give the obvious trigonometric functions.  They
respectively compute the cosine, sine, tangent, arc-cosine, arc-sine,
arc-tangent, and the two-argument arc-tangent.

\code{cospi(x)}, \code{sinpi(x)}, and \code{tanpi(x)}, compute
\code{cos(pi*x)}, \code{sin(pi*x)}, and \code{tan(pi*x)}.
}
\examples{
x <- dual(1, 1:0)
y <- dual(1, 0:1)

cos(x)
sin(x)
tan(x)
acos(x - 0.5)
asin(x - 0.5)
atan(x - 0.5)
atan2(x, y)
atan2(2.4, y)
atan2(x, 1.2)
cospi(1.2 * x)
sinpi(3.4 * x)
tanpi(5.6 * x)
}
