# Generated by 02-duckplyr_df-methods.R
#' @rdname filter.duckplyr_df
#' @export
filter.duckplyr_df <- function(.data, ..., .by = NULL, .preserve = FALSE) {
  force(.data)

  dots <- dplyr_quosures(...)
  check_filter(dots)

  by <- enquo(.by)

  duckplyr_error <- rel_try(list(name = "filter", x = .data, args = try_list(dots = dots, by = by, preserve = .preserve)),
    #' @section Fallbacks:
    #' There is no DuckDB translation in `filter.duckplyr_df()`
    #' - with no filter conditions,
    #' - nor for a grouped operation (if `.by` is set).
    #'
    #' These features fall back to [dplyr::filter()], see `vignette("fallback")` for details.
    "Can't use relational without filter conditions." = (length(dots) == 0),
    "{.code filter(by = ...)} not implemented, try {.code mutate(by = ...)} followed by a simple {.code filter()}." = (!quo_is_null(by)), # (length(by$names) > 0),
    {
      rel <- duckdb_rel_from_df(.data)
      exprs <- rel_translate_dots(dots, .data)

      # FIXME: Seems to be necessary only if alternations `|` are used in `exprs`.
      # Add only then?
      rel <- oo_prep(rel)

      rel <- rel_filter(rel, exprs)

      out_rel <- oo_restore(rel)

      out <- duckplyr_reconstruct(out_rel, .data)
      return(out)
    }
  )

  # dplyr forward
  check_prudence(.data, duckplyr_error)

  filter <- dplyr$filter.data.frame
  out <- filter(.data, ..., .by = {{ .by }}, .preserve = .preserve)
  return(out)

  # dplyr implementation
  dots <- dplyr_quosures(...)
  check_filter(dots)

  by <- compute_by(
    by = {{ .by }},
    data = .data,
    by_arg = ".by",
    data_arg = ".data"
  )

  loc <- filter_rows(.data, dots, by)
  dplyr_row_slice(.data, loc, preserve = .preserve)
}

duckplyr_filter <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df_impl(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- filter(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
