# Generated by duckplyr's 05-duckdb-tests.R, do not edit by hand

# anti_join order-preserving -----------------------------------------------------------

test_that("relational anti_join(join_by(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = 2)

  "anti_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "anti_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "anti_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "anti_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "anti_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "anti_join"
  rel6 <- duckdb$rel_join(
    rel5,
    rel4,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a", rel5), duckdb$expr_reference("a", rel4)))
    ),
    "anti"
  )
  "anti_join"
  rel7 <- duckdb$rel_order(rel6, list(duckdb$expr_reference("___row_number_x", rel5)))
  "anti_join"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel8
  out <- duckdb$rel_to_altrep(rel8)
  expect_identical(
    out,
    data.frame(a = 1L, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# anti_join order-enforcing ------------------------------------------------------------

test_that("relational anti_join(join_by(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = 2)

  "anti_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "anti_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "anti_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "anti_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "anti_join"
  rel5 <- duckdb$rel_join(
    rel2,
    rel4,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a", rel2), duckdb$expr_reference("a", rel4)))
    ),
    "anti"
  )
  "arrange"
  rel6 <- duckdb$rel_order(rel5, list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = 1L, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# arrange order-preserving -------------------------------------------------------------

test_that("relational arrange() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  rel1
  out <- duckdb$rel_to_altrep(rel1)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(a) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("a"), duckdb$expr_reference("___row_number")))
  "arrange"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("g"), duckdb$expr_reference("___row_number")))
  "arrange"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(g, a) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("g"), duckdb$expr_reference("a"), duckdb$expr_reference("___row_number"))
  )
  "arrange"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(a, g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("g"), duckdb$expr_reference("___row_number"))
  )
  "arrange"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# arrange order-enforcing --------------------------------------------------------------

test_that("relational arrange() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(a) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_order(rel1, list(duckdb$expr_reference("a")))
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_order(rel1, list(duckdb$expr_reference("g")))
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(g, a) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_order(rel1, list(duckdb$expr_reference("g"), duckdb$expr_reference("a")))
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational arrange(a, g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "arrange"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_order(rel1, list(duckdb$expr_reference("a"), duckdb$expr_reference("g")))
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# compute order-preserving -------------------------------------------------------------

test_that("relational compute() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "compute"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  rel1
  out <- duckdb$rel_to_altrep(rel1)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# count order-preserving ---------------------------------------------------------------

test_that("relational count() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(n = 6L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(a) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      a = {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), n = 1L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(b) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      b = {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(b = 2, n = 6L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = 1:3, n = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(g, a) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      a = {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), n = 1L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(b, g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      b = {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(b = 2, g = 1:3, n = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# count order-enforcing ----------------------------------------------------------------

test_that("relational count() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("n")))
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(n = 6L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(a) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      a = {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("a"), duckdb$expr_reference("n")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), n = 1L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(b) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      b = {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("b"), duckdb$expr_reference("n")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(b = 2, n = 6L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("g"), duckdb$expr_reference("n")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(g = 1:3, n = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(g, a) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      a = {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("g"), duckdb$expr_reference("a"), duckdb$expr_reference("n"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), n = 1L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational count(b, g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "count"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "count"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(
      b = {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    ),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "count"
  rel3 <- duckdb$rel_order(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("n"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(b = 2, g = 1:3, n = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# distinct order-preserving ------------------------------------------------------------

test_that("relational distinct() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- duckdb$expr_reference("a")
              duckdb$expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- duckdb$expr_reference("b")
              duckdb$expr_set_alias(tmp_expr, "b")
              tmp_expr
            },
            g = {
              tmp_expr <- duckdb$expr_reference("g")
              duckdb$expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- duckdb$rel_filter(
    rel3,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- duckdb$rel_order(rel4, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel6 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(a) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- duckdb$expr_reference("a")
              duckdb$expr_set_alias(tmp_expr, "a")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- duckdb$rel_filter(
    rel3,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- duckdb$rel_order(rel4, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel6 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(a, b) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- duckdb$expr_reference("a")
              duckdb$expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- duckdb$expr_reference("b")
              duckdb$expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- duckdb$rel_filter(
    rel3,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- duckdb$rel_order(rel4, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel6 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(b, b) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            b = {
              tmp_expr <- duckdb$expr_reference("b")
              duckdb$expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- duckdb$rel_filter(
    rel3,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- duckdb$rel_order(rel4, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel6 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- duckdb$expr_reference("g")
              duckdb$expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- duckdb$rel_filter(
    rel3,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- duckdb$rel_order(rel4, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel6 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 3, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- duckdb$rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("___row_number_x"), duckdb$expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- duckdb$rel_project(
    rel8,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- duckdb$expr_reference("g")
              duckdb$expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- duckdb$rel_filter(
    rel9,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- duckdb$rel_order(rel10, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel12 <- duckdb$rel_project(
    rel11,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- duckdb$rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 4, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- duckdb$rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("___row_number_x"), duckdb$expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- duckdb$rel_project(
    rel8,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- duckdb$expr_reference("g")
              duckdb$expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- duckdb$rel_filter(
    rel9,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- duckdb$rel_order(rel10, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel12 <- duckdb$rel_project(
    rel11,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- duckdb$rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 5, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- duckdb$rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("___row_number_x"), duckdb$expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- duckdb$rel_project(
    rel8,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- duckdb$expr_reference("g")
              duckdb$expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- duckdb$rel_filter(
    rel9,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- duckdb$rel_order(rel10, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel12 <- duckdb$rel_project(
    rel11,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- duckdb$rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 6, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- duckdb$rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("___row_number_x"), duckdb$expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- duckdb$rel_project(
    rel8,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- duckdb$expr_reference("g")
              duckdb$expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- duckdb$rel_filter(
    rel9,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- duckdb$rel_order(rel10, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel12 <- duckdb$rel_project(
    rel11,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- duckdb$rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 7, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- duckdb$rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("___row_number_x"), duckdb$expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- duckdb$rel_project(
    rel8,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- duckdb$expr_reference("g")
              duckdb$expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- duckdb$rel_filter(
    rel9,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- duckdb$rel_order(rel10, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel12 <- duckdb$rel_project(
    rel11,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel12
  out <- duckdb$rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(g, .keep_all = TRUE) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- duckdb$expr_reference("g")
              duckdb$expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- duckdb$rel_filter(
    rel3,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- duckdb$rel_order(rel4, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel6 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = c(1, 2, 4), b = 2, g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# distinct order-enforcing -------------------------------------------------------------

test_that("relational distinct() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_distinct(rel1)
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(a) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      a = {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_distinct(rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("a")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(a, b) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      a = {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      b = {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_distinct(rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(b, b) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      b = {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_distinct(rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("b")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_distinct(rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("g")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 3, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 3, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- duckdb$rel_distinct(rel4)
  "arrange"
  rel6 <- duckdb$rel_order(rel5, list(duckdb$expr_reference("g")))
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 4, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 4, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- duckdb$rel_distinct(rel4)
  "arrange"
  rel6 <- duckdb$rel_order(rel5, list(duckdb$expr_reference("g")))
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 5, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 5, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- duckdb$rel_distinct(rel4)
  "arrange"
  rel6 <- duckdb$rel_order(rel5, list(duckdb$expr_reference("g")))
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 6, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 6, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- duckdb$rel_distinct(rel4)
  "arrange"
  rel6 <- duckdb$rel_order(rel5, list(duckdb$expr_reference("g")))
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational union_all(data.frame(a = 1L, b = 7, g = 2L)) %>% distinct(g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 1L, b = 7, g = 2L)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      g = {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "distinct"
  rel5 <- duckdb$rel_distinct(rel4)
  "arrange"
  rel6 <- duckdb$rel_order(rel5, list(duckdb$expr_reference("g")))
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational distinct(g, .keep_all = TRUE) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "distinct"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "distinct"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            g = {
              tmp_expr <- duckdb$expr_reference("g")
              duckdb$expr_set_alias(tmp_expr, "g")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel4 <- duckdb$rel_filter(
    rel3,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel5 <- duckdb$rel_order(rel4, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel6 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel7 <- duckdb$rel_order(
    rel6,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel7
  out <- duckdb$rel_to_altrep(rel7)
  expect_identical(
    out,
    data.frame(a = c(1, 2, 4), b = 2, g = 1:3)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# filter order-preserving --------------------------------------------------------------

test_that("relational filter(a == 1) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "filter"
  rel3 <- duckdb$rel_filter(
    rel2,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("a"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1, experimental = experimental)
          } else {
            duckdb$expr_constant(1)
          }
        )
      )
    )
  )
  "filter"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "filter"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = 1, b = 2, g = 1L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a %in% 2:3, g == 2) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "filter"
  rel3 <- duckdb$rel_filter(
    rel2,
    list(
      duckdb$expr_function(
        "___coalesce",
        list(
          duckdb$expr_function(
            "|",
            list(
              duckdb$expr_function(
                "r_base::==",
                list(
                  duckdb$expr_reference("a"),
                  if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                    duckdb$expr_constant(2L, experimental = experimental)
                  } else {
                    duckdb$expr_constant(2L)
                  }
                )
              ),
              duckdb$expr_function(
                "r_base::==",
                list(
                  duckdb$expr_reference("a"),
                  if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                    duckdb$expr_constant(3L, experimental = experimental)
                  } else {
                    duckdb$expr_constant(3L)
                  }
                )
              )
            )
          ),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(FALSE, experimental = experimental)
          } else {
            duckdb$expr_constant(FALSE)
          }
        )
      ),
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("g"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          }
        )
      )
    )
  )
  "filter"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "filter"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = c(2, 3), b = 2, g = 2L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a %in% 2:3 & g == 2) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "&"(x, y) AS (x AND y)'))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "filter"
  rel3 <- duckdb$rel_filter(
    rel2,
    list(
      duckdb$expr_function(
        "&",
        list(
          duckdb$expr_function(
            "___coalesce",
            list(
              duckdb$expr_function(
                "|",
                list(
                  duckdb$expr_function(
                    "r_base::==",
                    list(
                      duckdb$expr_reference("a"),
                      if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                        duckdb$expr_constant(2L, experimental = experimental)
                      } else {
                        duckdb$expr_constant(2L)
                      }
                    )
                  ),
                  duckdb$expr_function(
                    "r_base::==",
                    list(
                      duckdb$expr_reference("a"),
                      if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                        duckdb$expr_constant(3L, experimental = experimental)
                      } else {
                        duckdb$expr_constant(3L)
                      }
                    )
                  )
                )
              ),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(FALSE, experimental = experimental)
              } else {
                duckdb$expr_constant(FALSE)
              }
            )
          ),
          duckdb$expr_comparison(
            "==",
            list(
              duckdb$expr_reference("g"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          )
        )
      )
    )
  )
  "filter"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "filter"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = c(2, 3), b = 2, g = 2L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a != 2 | g != 2) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "filter"
  rel3 <- duckdb$rel_filter(
    rel2,
    list(
      duckdb$expr_function(
        "|",
        list(
          duckdb$expr_function(
            "r_base::!=",
            list(
              duckdb$expr_reference("a"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          ),
          duckdb$expr_function(
            "r_base::!=",
            list(
              duckdb$expr_reference("g"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          )
        )
      )
    )
  )
  "filter"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "filter"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = c(1, 3, 4, 5, 6), b = 2, g = c(1L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# filter order-enforcing ---------------------------------------------------------------

test_that("relational filter(a == 1) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- duckdb$rel_filter(
    rel1,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("a"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1, experimental = experimental)
          } else {
            duckdb$expr_constant(1)
          }
        )
      )
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = 1, b = 2, g = 1L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a %in% 2:3, g == 2) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- duckdb$rel_filter(
    rel1,
    list(
      duckdb$expr_function(
        "___coalesce",
        list(
          duckdb$expr_function(
            "|",
            list(
              duckdb$expr_function(
                "r_base::==",
                list(
                  duckdb$expr_reference("a"),
                  if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                    duckdb$expr_constant(2L, experimental = experimental)
                  } else {
                    duckdb$expr_constant(2L)
                  }
                )
              ),
              duckdb$expr_function(
                "r_base::==",
                list(
                  duckdb$expr_reference("a"),
                  if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                    duckdb$expr_constant(3L, experimental = experimental)
                  } else {
                    duckdb$expr_constant(3L)
                  }
                )
              )
            )
          ),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(FALSE, experimental = experimental)
          } else {
            duckdb$expr_constant(FALSE)
          }
        )
      ),
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("g"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          }
        )
      )
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = c(2, 3), b = 2, g = 2L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a %in% 2:3 & g == 2) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "&"(x, y) AS (x AND y)'))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- duckdb$rel_filter(
    rel1,
    list(
      duckdb$expr_function(
        "&",
        list(
          duckdb$expr_function(
            "___coalesce",
            list(
              duckdb$expr_function(
                "|",
                list(
                  duckdb$expr_function(
                    "r_base::==",
                    list(
                      duckdb$expr_reference("a"),
                      if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                        duckdb$expr_constant(2L, experimental = experimental)
                      } else {
                        duckdb$expr_constant(2L)
                      }
                    )
                  ),
                  duckdb$expr_function(
                    "r_base::==",
                    list(
                      duckdb$expr_reference("a"),
                      if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                        duckdb$expr_constant(3L, experimental = experimental)
                      } else {
                        duckdb$expr_constant(3L)
                      }
                    )
                  )
                )
              ),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(FALSE, experimental = experimental)
              } else {
                duckdb$expr_constant(FALSE)
              }
            )
          ),
          duckdb$expr_comparison(
            "==",
            list(
              duckdb$expr_reference("g"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          )
        )
      )
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = c(2, 3), b = 2, g = 2L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational filter(a != 2 | g != 2) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  invisible(DBI::dbExecute(con, 'CREATE MACRO "|"(x, y) AS (x OR y)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "filter"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "filter"
  rel2 <- duckdb$rel_filter(
    rel1,
    list(
      duckdb$expr_function(
        "|",
        list(
          duckdb$expr_function(
            "r_base::!=",
            list(
              duckdb$expr_reference("a"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          ),
          duckdb$expr_function(
            "r_base::!=",
            list(
              duckdb$expr_reference("g"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          )
        )
      )
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = c(1, 3, 4, 5, 6), b = 2, g = c(1L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# full_join order-preserving -----------------------------------------------------------

test_that("relational full_join(join_by(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = 2)

  "full_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "full_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "full_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "full_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "full_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "full_join"
  rel6 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "full_join"
  rel7 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_x")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "full_join"
  rel8 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_y")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "full_join"
  rel9 <- duckdb$rel_join(
    rel7,
    rel8,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a_x", rel7), duckdb$expr_reference("a_y", rel8)))
    ),
    "outer"
  )
  "full_join"
  rel10 <- duckdb$rel_order(
    rel9,
    list(duckdb$expr_reference("___row_number_x", rel7), duckdb$expr_reference("___row_number_y", rel8))
  )
  "full_join"
  rel11 <- duckdb$rel_project(
    rel10,
    list(
      {
        tmp_expr <- duckdb$expr_function("___coalesce", list(duckdb$expr_reference("a_x", rel7), duckdb$expr_reference("a_y", rel8)))
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  rel11
  out <- duckdb$rel_to_altrep(rel11)
  expect_identical(
    out,
    data.frame(a = 1:5, b.x = rep(c(2, NA), c(4L, 1L)), b.y = rep(c(NA, 2), c(1L, 4L)))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# full_join order-enforcing ------------------------------------------------------------

test_that("relational full_join(join_by(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = 2)

  "full_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "full_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "full_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "full_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "full_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "full_join"
  rel6 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "full_join"
  rel7 <- duckdb$rel_join(
    rel5,
    rel6,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a_x", rel5), duckdb$expr_reference("a_y", rel6)))
    ),
    "outer"
  )
  "full_join"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_function("___coalesce", list(duckdb$expr_reference("a_x", rel5), duckdb$expr_reference("a_y", rel6)))
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  "arrange"
  rel9 <- duckdb$rel_order(
    rel8,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b.x"), duckdb$expr_reference("b.y"))
  )
  rel9
  out <- duckdb$rel_to_altrep(rel9)
  expect_identical(
    out,
    data.frame(a = 1:5, b.x = rep(c(2, NA), c(4L, 1L)), b.y = rep(c(NA, 2), c(1L, 4L)))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# inner_join order-preserving ----------------------------------------------------------

test_that("relational inner_join(join_by(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = 2)

  "inner_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "inner_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "inner_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "inner_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "inner_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel6 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel7 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_x")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel8 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_y")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel9 <- duckdb$rel_join(
    rel7,
    rel8,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a_x", rel7), duckdb$expr_reference("a_y", rel8)))
    ),
    "inner"
  )
  "inner_join"
  rel10 <- duckdb$rel_order(
    rel9,
    list(duckdb$expr_reference("___row_number_x", rel7), duckdb$expr_reference("___row_number_y", rel8))
  )
  "inner_join"
  rel11 <- duckdb$rel_project(
    rel10,
    list(
      {
        tmp_expr <- duckdb$expr_function("___coalesce", list(duckdb$expr_reference("a_x", rel7), duckdb$expr_reference("a_y", rel8)))
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  rel11
  out <- duckdb$rel_to_altrep(rel11)
  expect_identical(
    out,
    data.frame(a = 2:4, b.x = 2, b.y = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# inner_join order-enforcing -----------------------------------------------------------

test_that("relational inner_join(join_by(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = 2)

  "inner_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "inner_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "inner_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "inner_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "inner_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel6 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "inner_join"
  rel7 <- duckdb$rel_join(
    rel5,
    rel6,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a_x", rel5), duckdb$expr_reference("a_y", rel6)))
    ),
    "inner"
  )
  "inner_join"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_function("___coalesce", list(duckdb$expr_reference("a_x", rel5), duckdb$expr_reference("a_y", rel6)))
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  "arrange"
  rel9 <- duckdb$rel_order(
    rel8,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b.x"), duckdb$expr_reference("b.y"))
  )
  rel9
  out <- duckdb$rel_to_altrep(rel9)
  expect_identical(
    out,
    data.frame(a = 2:4, b.x = 2, b.y = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# intersect order-preserving -----------------------------------------------------------

test_that("relational intersect() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = 2)

  "semi_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "semi_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "semi_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "semi_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "semi_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "semi_join"
  rel6 <- duckdb$rel_join(
    rel5,
    rel4,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a", rel5), duckdb$expr_reference("a", rel4))),
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("b", rel5), duckdb$expr_reference("b", rel4)))
    ),
    "semi"
  )
  "semi_join"
  rel7 <- duckdb$rel_order(rel6, list(duckdb$expr_reference("___row_number_x", rel5)))
  "semi_join"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- duckdb$rel_project(
    rel8,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- duckdb$rel_project(
    rel9,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- duckdb$expr_reference("a")
              duckdb$expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- duckdb$expr_reference("b")
              duckdb$expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel11 <- duckdb$rel_filter(
    rel10,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel12 <- duckdb$rel_order(rel11, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel13 <- duckdb$rel_project(
    rel12,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel13
  out <- duckdb$rel_to_altrep(rel13)
  expect_identical(
    out,
    data.frame(a = 2:4, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# intersect order-enforcing ------------------------------------------------------------

test_that("relational intersect() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = 2)

  "intersect"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = 2)

  "intersect"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "intersect"
  rel3 <- duckdb$rel_set_intersect(rel1, rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = 2:4, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# left_join order-preserving -----------------------------------------------------------

test_that("relational left_join(join_by(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = 2)

  "left_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "left_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "left_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "left_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "left_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "left_join"
  rel6 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "left_join"
  rel7 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_x")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "left_join"
  rel8 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_y")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "left_join"
  rel9 <- duckdb$rel_join(
    rel7,
    rel8,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a_x", rel7), duckdb$expr_reference("a_y", rel8)))
    ),
    "left"
  )
  "left_join"
  rel10 <- duckdb$rel_order(
    rel9,
    list(duckdb$expr_reference("___row_number_x", rel7), duckdb$expr_reference("___row_number_y", rel8))
  )
  "left_join"
  rel11 <- duckdb$rel_project(
    rel10,
    list(
      {
        tmp_expr <- duckdb$expr_function("___coalesce", list(duckdb$expr_reference("a_x", rel7), duckdb$expr_reference("a_y", rel8)))
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  rel11
  out <- duckdb$rel_to_altrep(rel11)
  expect_identical(
    out,
    data.frame(a = 1:4, b.x = 2, b.y = c(NA, 2, 2, 2))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# left_join order-enforcing ------------------------------------------------------------

test_that("relational left_join(join_by(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___coalesce"(x, y) AS COALESCE(x, y)'))
  df1 <- data.frame(a = 1:4, b = 2)

  "left_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "left_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "left_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "left_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "left_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "left_join"
  rel6 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "left_join"
  rel7 <- duckdb$rel_join(
    rel5,
    rel6,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a_x", rel5), duckdb$expr_reference("a_y", rel6)))
    ),
    "left"
  )
  "left_join"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_function("___coalesce", list(duckdb$expr_reference("a_x", rel5), duckdb$expr_reference("a_y", rel6)))
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  "arrange"
  rel9 <- duckdb$rel_order(
    rel8,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b.x"), duckdb$expr_reference("b.y"))
  )
  rel9
  out <- duckdb$rel_to_altrep(rel9)
  expect_identical(
    out,
    data.frame(a = 1:4, b.x = 2, b.y = c(NA, 2, 2, 2))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# mutate order-preserving --------------------------------------------------------------

test_that("relational mutate() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  rel1
  out <- duckdb$rel_to_altrep(rel1)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a + 1) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a + 1` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a + 1, .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("a + 1")
        duckdb$expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a + 1` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = a + 1) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = seq(2, 7, by = 1)
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(`if` = a + 1) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "if")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `if` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sum(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("sum", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sum(a)` = 21,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sum(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("sum", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("sum(a)")
        duckdb$expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sum(a)` = c(1, 5, 5, 15, 15, 15),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(mean(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("mean", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `mean(a)` = 3.5,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(mean(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("mean", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("mean(a)")
        duckdb$expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `mean(a)` = c(1, 2.5, 2.5, 5, 5, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sd(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("stddev", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sd(a)` = 0x1.deeea11683f49p+0,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sd(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("stddev", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("sd(a)")
        duckdb$expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sd(a)` = c(NA, 0.7071067811865476, 0.7071067811865476, 1, 1, 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a)` = c(NA, 1, 2, 3, 4, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("lag(a)")
        duckdb$expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a)` = c(NA, NA, 2, NA, 4, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a)` = c(2, 3, 4, 5, 6, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("lead(a)")
        duckdb$expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a)` = c(NA, 3, NA, 5, 6, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 2)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 2)` = c(NA, NA, 1, 2, 3, 4),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 2), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("lag(a, 2)")
        duckdb$expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 2)` = rep(c(NA, 4), c(5L, 1L)),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 2)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 2)` = c(3, 4, 5, 6, NA, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 2), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("lead(a, 2)")
        duckdb$expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 2)` = c(NA, NA, NA, 6, NA, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 4)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(4, experimental = experimental)
          } else {
            duckdb$expr_constant(4)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 4)` = c(NA, NA, NA, NA, 1, 2),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 4), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(4, experimental = experimental)
          } else {
            duckdb$expr_constant(4)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("lag(a, 4)")
        duckdb$expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 4)` = NA_real_,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 4)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(4, experimental = experimental)
          } else {
            duckdb$expr_constant(4)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 4)` = c(5, 6, NA, NA, NA, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 4), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(4, experimental = experimental)
          } else {
            duckdb$expr_constant(4)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("lead(a, 4)")
        duckdb$expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 4)` = NA_real_,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, default = 0)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(0, experimental = experimental)
          } else {
            duckdb$expr_constant(0)
          }
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, default = 0)` = seq(0, 5, by = 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, default = 0), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(0, experimental = experimental)
          } else {
            duckdb$expr_constant(0)
          }
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("lag(a, default = 0)")
        duckdb$expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, default = 0)` = c(0, 0, 2, 0, 4, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, default = 1000)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1000, experimental = experimental)
          } else {
            duckdb$expr_constant(1000)
          }
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, default = 1000)` = c(2, 3, 4, 5, 6, 1000),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, default = 1000), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1000, experimental = experimental)
          } else {
            duckdb$expr_constant(1000)
          }
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("lead(a, default = 1000)")
        duckdb$expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, default = 1000)` = c(1000, 3, 1000, 5, 6, 1000),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(min(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("min", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `min(a)` = 1,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(min(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("min", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("min(a)")
        duckdb$expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `min(a)` = c(1, 2, 2, 4, 4, 4),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(max(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("max", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `max(a)` = 6,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(max(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("max", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("max(a)")
        duckdb$expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `max(a)` = c(1, 3, 3, 6, 6, 6),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(first(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("first_value", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `first(a)` = 1,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(first(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("first_value", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("first(a)")
        duckdb$expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `first(a)` = c(1, 2, 2, 4, 4, 4),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(last(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("last_value", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `last(a)` = 6,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(last(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("last_value", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("last(a)")
        duckdb$expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `last(a)` = c(1, 3, 3, 6, 6, 6),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(nth(a, 2)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function(
            "nth_value",
            list(
              duckdb$expr_reference("a"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          ),
          list(),
          list(),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `nth(a, 2)` = 2,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(nth(a, 2), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function(
            "nth_value",
            list(
              duckdb$expr_reference("a"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          ),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("nth(a, 2)")
        duckdb$expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `nth(a, 2)` = c(NA, 3, 3, 5, 5, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a / b) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___divide"(x, y) AS CASE WHEN y = 0 THEN CASE WHEN x = 0 THEN CAST('NaN' AS double) WHEN x > 0 THEN CAST('+Infinity' AS double) ELSE CAST('-Infinity' AS double) END ELSE CAST(x AS double) / y END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___divide", list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
        duckdb$expr_set_alias(tmp_expr, "a/b")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a/b` = seq(0.5, 3, by = 0.5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = 0, e = 1 / d, f = 0 / d, g = -1 / d) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___divide"(x, y) AS CASE WHEN y = 0 THEN CASE WHEN x = 0 THEN CAST('NaN' AS double) WHEN x > 0 THEN CAST('+Infinity' AS double) ELSE CAST('-Infinity' AS double) END ELSE CAST(x AS double) / y END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(0, experimental = experimental)
        } else {
          duckdb$expr_constant(0)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "___divide",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            },
            duckdb$expr_reference("d")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("e")
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "___divide",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(0, experimental = experimental)
            } else {
              duckdb$expr_constant(0)
            },
            duckdb$expr_reference("d")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "___divide",
          list(
            duckdb$expr_function(
              "-",
              list(
                if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                  duckdb$expr_constant(1, experimental = experimental)
                } else {
                  duckdb$expr_constant(1)
                }
              )
            ),
            duckdb$expr_reference("d")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("e")
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("f")
        duckdb$expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = -Inf, d = 0, e = Inf, f = NaN)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 0, d = -1, e = log(c), f = suppressWarnings(log(d))) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___log"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE ln(x) END]"
    )
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "suppressWarnings"(x) AS (x)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(0, experimental = experimental)
        } else {
          duckdb$expr_constant(0)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "-",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___log", list(duckdb$expr_reference("c")))
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("e")
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("suppressWarnings", list(duckdb$expr_function("___log", list(duckdb$expr_reference("d")))))
        duckdb$expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = 0,
      d = -1,
      e = -Inf,
      f = NaN
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 0, d = -1, e = log10(c), f = suppressWarnings(log10(d))) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___log10"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE log10(x) END]"
    )
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "suppressWarnings"(x) AS (x)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(0, experimental = experimental)
        } else {
          duckdb$expr_constant(0)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "-",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___log10", list(duckdb$expr_reference("c")))
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("e")
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("suppressWarnings", list(duckdb$expr_function("___log10", list(duckdb$expr_reference("d")))))
        duckdb$expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = 0,
      d = -1,
      e = -Inf,
      f = NaN
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 10, d = log(c)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___log"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE ln(x) END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(10, experimental = experimental)
        } else {
          duckdb$expr_constant(10)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___log", list(duckdb$expr_reference("c")))
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = 10,
      d = 2.302585092994046
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 10, d = log10(c)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___log10"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE log10(x) END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(10, experimental = experimental)
        } else {
          duckdb$expr_constant(10)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___log10", list(duckdb$expr_reference("c")))
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), c = 10, d = 1)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = NA_character_, d = grepl('.', c)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      'CREATE MACRO "grepl"(pattern, x) AS (CASE WHEN x IS NULL THEN FALSE ELSE regexp_matches(x, pattern) END)'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_character_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_character_)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "grepl",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(".", experimental = experimental)
            } else {
              duckdb$expr_constant(".")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = NA_character_,
      d = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 'abbc', d = gsub('(b|c)', 'z' , c)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "gsub"(pattern, replacement, x) AS (regexp_replace(x, pattern, replacement, 'g'))]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant("abbc", experimental = experimental)
        } else {
          duckdb$expr_constant("abbc")
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "gsub",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("(b|c)", experimental = experimental)
            } else {
              duckdb$expr_constant("(b|c)")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("z", experimental = experimental)
            } else {
              duckdb$expr_constant("z")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = "abbc",
      d = "azzz"
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 'abbc', d = sub('(b|c)', 'z' , c)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      'CREATE MACRO "sub"(pattern, replacement, x) AS (regexp_replace(x, pattern, replacement))'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant("abbc", experimental = experimental)
        } else {
          duckdb$expr_constant("abbc")
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "sub",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("(b|c)", experimental = experimental)
            } else {
              duckdb$expr_constant("(b|c)")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("z", experimental = experimental)
            } else {
              duckdb$expr_constant("z")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = "abbc",
      d = "azbc"
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = NA_character_, d = gsub('.', '-' , c)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "gsub"(pattern, replacement, x) AS (regexp_replace(x, pattern, replacement, 'g'))]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_character_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_character_)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "gsub",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(".", experimental = experimental)
            } else {
              duckdb$expr_constant(".")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("-", experimental = experimental)
            } else {
              duckdb$expr_constant("-")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = NA_character_,
      d = NA_character_
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = NA_character_, d = sub('.', '-' , c)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      'CREATE MACRO "sub"(pattern, replacement, x) AS (regexp_replace(x, pattern, replacement))'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_character_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_character_)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "sub",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(".", experimental = experimental)
            } else {
              duckdb$expr_constant(".")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("-", experimental = experimental)
            } else {
              duckdb$expr_constant("-")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = NA_character_,
      d = NA_character_
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% NA_real_) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("is.na", list(duckdb$expr_reference("a")))
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = FALSE)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% NULL) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(FALSE, experimental = experimental)
        } else {
          duckdb$expr_constant(FALSE)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = FALSE)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% integer()) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(FALSE, experimental = experimental)
        } else {
          duckdb$expr_constant(FALSE)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = FALSE)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_real_, e = is.na(d)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_real_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_real_)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("is.na", list(duckdb$expr_reference("d")))
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = NA_real_,
      e = TRUE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = row_number()) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "r_base::as.integer",
          list(
            duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = 1:6)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = row_number(), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("___row_number")
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "r_base::as.integer",
          list(
            duckdb$expr_window(duckdb$expr_function("row_number", list()), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = c(1L, 1L, 2L, 1L, 2L, 3L)
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = .data$b) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), c = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___null"() AS CAST(NULL AS BOOLEAN)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___null", list())
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = NA)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_integer_) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = NA_integer_)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_real_) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_real_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_real_)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = NA_real_)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_character_) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_character_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_character_)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = NA_character_)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = if_else(a > 1, \"ok\", NA)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      'CREATE MACRO "if_else"(test, yes, no) AS (CASE WHEN test IS NULL THEN NULL ELSE CASE WHEN test THEN yes ELSE no END END)'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "if_else",
          list(
            duckdb$expr_comparison(
              ">",
              list(
                duckdb$expr_reference("a"),
                if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                  duckdb$expr_constant(1, experimental = experimental)
                } else {
                  duckdb$expr_constant(1)
                }
              )
            ),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("ok", experimental = experimental)
            } else {
              duckdb$expr_constant("ok")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(NA, experimental = experimental)
            } else {
              duckdb$expr_constant(NA)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(c(NA, "ok"), c(1L, 5L))
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# mutate order-enforcing ---------------------------------------------------------------

test_that("relational mutate() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "arrange"
  rel2 <- duckdb$rel_order(
    rel1,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a + 1) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("a + 1"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a + 1` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a + 1, .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "a + 1")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("a + 1"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a + 1` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = a + 1) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = seq(2, 7, by = 1)
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(`if` = a + 1) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "if")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("if"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `if` = seq(2, 7, by = 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sum(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("sum", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("sum(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sum(a)` = 21,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sum(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("sum", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "sum(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("sum(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sum(a)` = c(1, 5, 5, 15, 15, 15),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(mean(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("mean", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("mean(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `mean(a)` = 3.5,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(mean(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("mean", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "mean(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("mean(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `mean(a)` = c(1, 2.5, 2.5, 5, 5, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sd(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("stddev", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("sd(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sd(a)` = 0x1.deeea11683f49p+0,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(sd(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("stddev", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "sd(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("sd(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `sd(a)` = c(NA, 0.7071067811865476, 0.7071067811865476, 1, 1, 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lag(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a)` = c(NA, 1, 2, 3, 4, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lag(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a)` = c(NA, NA, 2, NA, 4, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lead(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a)` = c(2, 3, 4, 5, 6, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lead(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a)` = c(NA, 3, NA, 5, 6, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 2)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lag(a, 2)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 2)` = c(NA, NA, 1, 2, 3, 4),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 2), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lag(a, 2)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 2)` = rep(c(NA, 4), c(5L, 1L)),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 2)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lead(a, 2)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 2)` = c(3, 4, 5, 6, NA, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 2), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(2, experimental = experimental)
          } else {
            duckdb$expr_constant(2)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lead(a, 2)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 2)` = c(NA, NA, NA, 6, NA, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 4)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(4, experimental = experimental)
          } else {
            duckdb$expr_constant(4)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lag(a, 4)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 4)` = c(NA, NA, NA, NA, 1, 2),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, 4), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(4, experimental = experimental)
          } else {
            duckdb$expr_constant(4)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, 4)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lag(a, 4)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, 4)` = NA_real_,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 4)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(4, experimental = experimental)
          } else {
            duckdb$expr_constant(4)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lead(a, 4)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 4)` = c(5, 6, NA, NA, NA, NA),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, 4), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(4, experimental = experimental)
          } else {
            duckdb$expr_constant(4)
          },
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, 4)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lead(a, 4)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, 4)` = NA_real_,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, default = 0)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(0, experimental = experimental)
          } else {
            duckdb$expr_constant(0)
          }
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lag(a, default = 0)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, default = 0)` = seq(0, 5, by = 1),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lag(a, default = 0), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lag", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(0, experimental = experimental)
          } else {
            duckdb$expr_constant(0)
          }
        )
        duckdb$expr_set_alias(tmp_expr, "lag(a, default = 0)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lag(a, default = 0)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lag(a, default = 0)` = c(0, 0, 2, 0, 4, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, default = 1000)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1000, experimental = experimental)
          } else {
            duckdb$expr_constant(1000)
          }
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lead(a, default = 1000)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, default = 1000)` = c(2, 3, 4, 5, 6, 1000),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(lead(a, default = 1000), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("lead", list(x = duckdb$expr_reference("a"))),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          },
          default_expr = if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1000, experimental = experimental)
          } else {
            duckdb$expr_constant(1000)
          }
        )
        duckdb$expr_set_alias(tmp_expr, "lead(a, default = 1000)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("lead(a, default = 1000)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `lead(a, default = 1000)` = c(1000, 3, 1000, 5, 6, 1000),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(min(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("min", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("min(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `min(a)` = 1,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(min(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("min", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "min(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("min(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `min(a)` = c(1, 2, 2, 4, 4, 4),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(max(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("max", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("max(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `max(a)` = 6,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(max(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("max", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "max(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("max(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `max(a)` = c(1, 3, 3, 6, 6, 6),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(first(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("first_value", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("first(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `first(a)` = 1,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(first(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("first_value", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "first(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("first(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `first(a)` = c(1, 2, 2, 4, 4, 4),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(last(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("last_value", list(duckdb$expr_reference("a"))), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("last(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `last(a)` = 6,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(last(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("last_value", list(duckdb$expr_reference("a"))), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "last(a)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("last(a)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `last(a)` = c(1, 3, 3, 6, 6, 6),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(nth(a, 2)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function(
            "nth_value",
            list(
              duckdb$expr_reference("a"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          ),
          list(),
          list(),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("nth(a, 2)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `nth(a, 2)` = 2,
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(nth(a, 2), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function(
            "nth_value",
            list(
              duckdb$expr_reference("a"),
              if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                duckdb$expr_constant(2, experimental = experimental)
              } else {
                duckdb$expr_constant(2)
              }
            )
          ),
          list(duckdb$expr_reference("g")),
          list(),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "nth(a, 2)")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("nth(a, 2)"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `nth(a, 2)` = c(NA, 3, 3, 5, 5, 5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(a / b) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___divide"(x, y) AS CASE WHEN y = 0 THEN CASE WHEN x = 0 THEN CAST('NaN' AS double) WHEN x > 0 THEN CAST('+Infinity' AS double) ELSE CAST('-Infinity' AS double) END ELSE CAST(x AS double) / y END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___divide", list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
        duckdb$expr_set_alias(tmp_expr, "a/b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("a/b"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      `a/b` = seq(0.5, 3, by = 0.5),
      check.names = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = 0, e = 1 / d, f = 0 / d, g = -1 / d) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___divide"(x, y) AS CASE WHEN y = 0 THEN CASE WHEN x = 0 THEN CAST('NaN' AS double) WHEN x > 0 THEN CAST('+Infinity' AS double) ELSE CAST('-Infinity' AS double) END ELSE CAST(x AS double) / y END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(0, experimental = experimental)
        } else {
          duckdb$expr_constant(0)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "___divide",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            },
            duckdb$expr_reference("d")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("e")
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "___divide",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(0, experimental = experimental)
            } else {
              duckdb$expr_constant(0)
            },
            duckdb$expr_reference("d")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "___divide",
          list(
            duckdb$expr_function(
              "-",
              list(
                if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                  duckdb$expr_constant(1, experimental = experimental)
                } else {
                  duckdb$expr_constant(1)
                }
              )
            ),
            duckdb$expr_reference("d")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("e")
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("f")
        duckdb$expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "arrange"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"), duckdb$expr_reference("e"), duckdb$expr_reference("f"))
  )
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = -Inf, d = 0, e = Inf, f = NaN)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 0, d = -1, e = log(c), f = suppressWarnings(log(d))) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___log"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE ln(x) END]"
    )
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "suppressWarnings"(x) AS (x)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(0, experimental = experimental)
        } else {
          duckdb$expr_constant(0)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "-",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___log", list(duckdb$expr_reference("c")))
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("e")
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("suppressWarnings", list(duckdb$expr_function("___log", list(duckdb$expr_reference("d")))))
        duckdb$expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "arrange"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"), duckdb$expr_reference("d"), duckdb$expr_reference("e"), duckdb$expr_reference("f"))
  )
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = 0,
      d = -1,
      e = -Inf,
      f = NaN
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 0, d = -1, e = log10(c), f = suppressWarnings(log10(d))) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___log10"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE log10(x) END]"
    )
  )
  invisible(DBI::dbExecute(con, 'CREATE MACRO "suppressWarnings"(x) AS (x)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(0, experimental = experimental)
        } else {
          duckdb$expr_constant(0)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "-",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel4 <- duckdb$rel_project(
    rel3,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___log10", list(duckdb$expr_reference("c")))
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "mutate"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("e")
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("suppressWarnings", list(duckdb$expr_function("___log10", list(duckdb$expr_reference("d")))))
        duckdb$expr_set_alias(tmp_expr, "f")
        tmp_expr
      }
    )
  )
  "arrange"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"), duckdb$expr_reference("d"), duckdb$expr_reference("e"), duckdb$expr_reference("f"))
  )
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = 0,
      d = -1,
      e = -Inf,
      f = NaN
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 10, d = log(c)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___log"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE ln(x) END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(10, experimental = experimental)
        } else {
          duckdb$expr_constant(10)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___log", list(duckdb$expr_reference("c")))
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"), duckdb$expr_reference("d"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = 10,
      d = 2.302585092994046
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 10, d = log10(c)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "___log10"(x) AS CASE WHEN x < 0 THEN CAST('NaN' AS double) WHEN x = 0 THEN CAST('-Inf' AS double) ELSE log10(x) END]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(10, experimental = experimental)
        } else {
          duckdb$expr_constant(10)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___log10", list(duckdb$expr_reference("c")))
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"), duckdb$expr_reference("d"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), c = 10, d = 1)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = NA_character_, d = grepl('.', c)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      'CREATE MACRO "grepl"(pattern, x) AS (CASE WHEN x IS NULL THEN FALSE ELSE regexp_matches(x, pattern) END)'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_character_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_character_)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "grepl",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(".", experimental = experimental)
            } else {
              duckdb$expr_constant(".")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"), duckdb$expr_reference("d"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = NA_character_,
      d = FALSE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 'abbc', d = gsub('(b|c)', 'z' , c)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "gsub"(pattern, replacement, x) AS (regexp_replace(x, pattern, replacement, 'g'))]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant("abbc", experimental = experimental)
        } else {
          duckdb$expr_constant("abbc")
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "gsub",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("(b|c)", experimental = experimental)
            } else {
              duckdb$expr_constant("(b|c)")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("z", experimental = experimental)
            } else {
              duckdb$expr_constant("z")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"), duckdb$expr_reference("d"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = "abbc",
      d = "azzz"
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = 'abbc', d = sub('(b|c)', 'z' , c)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      'CREATE MACRO "sub"(pattern, replacement, x) AS (regexp_replace(x, pattern, replacement))'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant("abbc", experimental = experimental)
        } else {
          duckdb$expr_constant("abbc")
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "sub",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("(b|c)", experimental = experimental)
            } else {
              duckdb$expr_constant("(b|c)")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("z", experimental = experimental)
            } else {
              duckdb$expr_constant("z")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"), duckdb$expr_reference("d"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = "abbc",
      d = "azbc"
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = NA_character_, d = gsub('.', '-' , c)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      r"[CREATE MACRO "gsub"(pattern, replacement, x) AS (regexp_replace(x, pattern, replacement, 'g'))]"
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_character_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_character_)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "gsub",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(".", experimental = experimental)
            } else {
              duckdb$expr_constant(".")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("-", experimental = experimental)
            } else {
              duckdb$expr_constant("-")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"), duckdb$expr_reference("d"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = NA_character_,
      d = NA_character_
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = NA_character_, d = sub('.', '-' , c)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      'CREATE MACRO "sub"(pattern, replacement, x) AS (regexp_replace(x, pattern, replacement))'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_character_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_character_)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "sub",
          list(
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(".", experimental = experimental)
            } else {
              duckdb$expr_constant(".")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("-", experimental = experimental)
            } else {
              duckdb$expr_constant("-")
            },
            duckdb$expr_reference("c")
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"), duckdb$expr_reference("d"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      c = NA_character_,
      d = NA_character_
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% NA_real_) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("is.na", list(duckdb$expr_reference("a")))
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = FALSE)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% NULL) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(FALSE, experimental = experimental)
        } else {
          duckdb$expr_constant(FALSE)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = FALSE)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = a %in% integer()) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(FALSE, experimental = experimental)
        } else {
          duckdb$expr_constant(FALSE)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = FALSE)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_real_, e = is.na(d)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "is.na"(x) AS (x IS NULL)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_real_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_real_)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "mutate"
  rel3 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("d")
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("is.na", list(duckdb$expr_reference("d")))
        duckdb$expr_set_alias(tmp_expr, "e")
        tmp_expr
      }
    )
  )
  "arrange"
  rel4 <- duckdb$rel_order(
    rel3,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"), duckdb$expr_reference("e"))
  )
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = NA_real_,
      e = TRUE
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = row_number()) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "r_base::as.integer",
          list(
            duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = 1:6)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = row_number(), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(duckdb$rapi_load_rfuns(drv@database_ref))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "r_base::as.integer",
          list(
            duckdb$expr_window(duckdb$expr_function("row_number", list()), list(duckdb$expr_reference("g")), list(), offset_expr = NULL, default_expr = NULL)
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = c(1L, 1L, 2L, 1L, 2L, 3L)
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(c = .data$b) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("c"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), c = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "___null"() AS CAST(NULL AS BOOLEAN)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("___null", list())
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = NA)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_integer_) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = NA_integer_)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_real_) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_real_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_real_)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = NA_real_)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = NA_character_) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_character_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_character_)
        }
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L), d = NA_character_)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational mutate(d = if_else(a > 1, \"ok\", NA)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(
      con,
      'CREATE MACRO "if_else"(test, yes, no) AS (CASE WHEN test IS NULL THEN NULL ELSE CASE WHEN test THEN yes ELSE no END END)'
    )
  )
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "mutate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "mutate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "if_else",
          list(
            duckdb$expr_comparison(
              ">",
              list(
                duckdb$expr_reference("a"),
                if ("experimental" %in% names(formals(duckdb$expr_constant))) {
                  duckdb$expr_constant(1, experimental = experimental)
                } else {
                  duckdb$expr_constant(1)
                }
              )
            ),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant("ok", experimental = experimental)
            } else {
              duckdb$expr_constant("ok")
            },
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(NA, experimental = experimental)
            } else {
              duckdb$expr_constant(NA)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "d")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"), duckdb$expr_reference("d"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(
      a = seq(1, 6, by = 1),
      b = 2,
      g = c(1L, 2L, 2L, 3L, 3L, 3L),
      d = rep(c(NA, "ok"), c(1L, 5L))
    )
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# relocate order-preserving ------------------------------------------------------------

test_that("relational relocate(g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(a) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(g, .before = b) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), g = c(1L, 2L, 2L, 3L, 3L, 3L), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(a:b, .after = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# relocate order-enforcing -------------------------------------------------------------

test_that("relational relocate(g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("g"), duckdb$expr_reference("a"), duckdb$expr_reference("b"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(a) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(g, .before = b) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("g"), duckdb$expr_reference("b"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), g = c(1L, 2L, 2L, 3L, 3L, 3L), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational relocate(a:b, .after = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "relocate"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "relocate"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("g"), duckdb$expr_reference("a"), duckdb$expr_reference("b"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = c(1L, 2L, 2L, 3L, 3L, 3L), a = seq(1, 6, by = 1), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# rename order-preserving --------------------------------------------------------------

test_that("relational rename() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "rename"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "rename"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational rename(c = a) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "rename"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "rename"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(c = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# rename order-enforcing ---------------------------------------------------------------

test_that("relational rename() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "rename"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "rename"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational rename(c = a) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "rename"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "rename"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("c"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(c = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# right_join order-preserving ----------------------------------------------------------

test_that("relational right_join(join_by(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = 2)

  "right_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "right_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "right_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "right_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "right_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "right_join"
  rel6 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "right_join"
  rel7 <- duckdb$rel_project(
    rel5,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_x")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "right_join"
  rel8 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_y")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "right_join"
  rel9 <- duckdb$rel_join(
    rel7,
    rel8,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a_x", rel7), duckdb$expr_reference("a_y", rel8)))
    ),
    "right"
  )
  "right_join"
  rel10 <- duckdb$rel_order(
    rel9,
    list(duckdb$expr_reference("___row_number_x", rel7), duckdb$expr_reference("___row_number_y", rel8))
  )
  "right_join"
  rel11 <- duckdb$rel_project(
    rel10,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_y", rel8)
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  rel11
  out <- duckdb$rel_to_altrep(rel11)
  expect_identical(
    out,
    data.frame(a = 2:5, b.x = c(2, 2, 2, NA), b.y = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# right_join order-enforcing -----------------------------------------------------------

test_that("relational right_join(join_by(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = 2)

  "right_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "right_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "right_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "right_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "right_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_x")
        tmp_expr
      }
    )
  )
  "right_join"
  rel6 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a_y")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b_y")
        tmp_expr
      }
    )
  )
  "right_join"
  rel7 <- duckdb$rel_join(
    rel5,
    rel6,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a_x", rel5), duckdb$expr_reference("a_y", rel6)))
    ),
    "right"
  )
  "right_join"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a_y", rel6)
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_x")
        duckdb$expr_set_alias(tmp_expr, "b.x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b_y")
        duckdb$expr_set_alias(tmp_expr, "b.y")
        tmp_expr
      }
    )
  )
  "arrange"
  rel9 <- duckdb$rel_order(
    rel8,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b.x"), duckdb$expr_reference("b.y"))
  )
  rel9
  out <- duckdb$rel_to_altrep(rel9)
  expect_identical(
    out,
    data.frame(a = 2:5, b.x = c(2, 2, 2, NA), b.y = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# select order-preserving --------------------------------------------------------------

test_that("relational select(a) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational select(-g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational select(everything()) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# select order-enforcing ---------------------------------------------------------------

test_that("relational select(a) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("a")))
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational select(-g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational select(everything()) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "select"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "select"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(
    rel2,
    list(duckdb$expr_reference("a"), duckdb$expr_reference("b"), duckdb$expr_reference("g"))
  )
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# semi_join order-preserving -----------------------------------------------------------

test_that("relational semi_join(join_by(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = 2)

  "semi_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "semi_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "semi_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "semi_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "semi_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "semi_join"
  rel6 <- duckdb$rel_join(
    rel5,
    rel4,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a", rel5), duckdb$expr_reference("a", rel4)))
    ),
    "semi"
  )
  "semi_join"
  rel7 <- duckdb$rel_order(rel6, list(duckdb$expr_reference("___row_number_x", rel5)))
  "semi_join"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel8
  out <- duckdb$rel_to_altrep(rel8)
  expect_identical(
    out,
    data.frame(a = 2:4, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# semi_join order-enforcing ------------------------------------------------------------

test_that("relational semi_join(join_by(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = 2)

  "semi_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "semi_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "semi_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "semi_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "semi_join"
  rel5 <- duckdb$rel_join(
    rel2,
    rel4,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a", rel2), duckdb$expr_reference("a", rel4)))
    ),
    "semi"
  )
  "arrange"
  rel6 <- duckdb$rel_order(rel5, list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
  rel6
  out <- duckdb$rel_to_altrep(rel6)
  expect_identical(
    out,
    data.frame(a = 2:4, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# setdiff order-preserving -------------------------------------------------------------

test_that("relational setdiff() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = 2)

  "anti_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "anti_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "anti_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "anti_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "anti_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "anti_join"
  rel6 <- duckdb$rel_join(
    rel5,
    rel4,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a", rel5), duckdb$expr_reference("a", rel4))),
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("b", rel5), duckdb$expr_reference("b", rel4)))
    ),
    "anti"
  )
  "anti_join"
  rel7 <- duckdb$rel_order(rel6, list(duckdb$expr_reference("___row_number_x", rel5)))
  "anti_join"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- duckdb$rel_project(
    rel8,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- duckdb$rel_project(
    rel9,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- duckdb$expr_reference("a")
              duckdb$expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- duckdb$expr_reference("b")
              duckdb$expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel11 <- duckdb$rel_filter(
    rel10,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel12 <- duckdb$rel_order(rel11, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel13 <- duckdb$rel_project(
    rel12,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel13
  out <- duckdb$rel_to_altrep(rel13)
  expect_identical(
    out,
    data.frame(a = 1L, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# setdiff order-enforcing --------------------------------------------------------------

test_that("relational setdiff() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = 2)

  "setdiff"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = 2)

  "setdiff"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "setdiff"
  rel3 <- duckdb$rel_set_diff(rel1, rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = 1L, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# summarise order-preserving -----------------------------------------------------------

test_that("relational summarise(c = mean(a)) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("mean", list(duckdb$expr_reference("a")))
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_distinct(rel2)
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(c = 3.5)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = mean(a), .by = b) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_aggregate(
    rel2,
    groups = list(duckdb$expr_reference("b")),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("min", list(duckdb$expr_reference("___row_number")))
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("mean", list(duckdb$expr_reference("a")))
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "summarise"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(b = 2, c = 3.5)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = mean(a), .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_aggregate(
    rel2,
    groups = list(duckdb$expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("min", list(duckdb$expr_reference("___row_number")))
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function("mean", list(duckdb$expr_reference("a")))
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "summarise"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(g = 1:3, c = c(1, 2.5, 5))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = 1) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(1, experimental = experimental)
        } else {
          duckdb$expr_constant(1)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_distinct(rel2)
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(c = 1)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = 1, .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_aggregate(
    rel2,
    groups = list(duckdb$expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("min", list(duckdb$expr_reference("___row_number")))
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(1, experimental = experimental)
        } else {
          duckdb$expr_constant(1)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "summarise"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("c")
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(g = 1:3, c = 1)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(n = n(), n = n() + 1L, .by = g) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_aggregate(
    rel2,
    groups = list(duckdb$expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("min", list(duckdb$expr_reference("___row_number")))
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_function("n", list()),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1L, experimental = experimental)
            } else {
              duckdb$expr_constant(1L)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("___row_number")))
  "summarise"
  rel5 <- duckdb$rel_project(
    rel4,
    list(
      {
        tmp_expr <- duckdb$expr_reference("g")
        duckdb$expr_set_alias(tmp_expr, "g")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("n")
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(g = 1:3, n = 2:4)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(n = n(), n = n() + 1L) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_function("n", list()),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1L, experimental = experimental)
            } else {
              duckdb$expr_constant(1L)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_distinct(rel2)
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(n = 7L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# summarise order-enforcing ------------------------------------------------------------

test_that("relational summarise(c = mean(a)) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("mean", list(duckdb$expr_reference("a")))
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_distinct(rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("c")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(c = 3.5)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = mean(a), .by = b) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(duckdb$expr_reference("b")),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("mean", list(duckdb$expr_reference("a")))
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("b"), duckdb$expr_reference("c")))
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(b = 2, c = 3.5)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = mean(a), .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(duckdb$expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("mean", list(duckdb$expr_reference("a")))
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("g"), duckdb$expr_reference("c")))
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = 1:3, c = c(1, 2.5, 5))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = 1) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(1, experimental = experimental)
        } else {
          duckdb$expr_constant(1)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_distinct(rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("c")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(c = 1)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(c = 1, .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(duckdb$expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(1, experimental = experimental)
        } else {
          duckdb$expr_constant(1)
        }
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("g"), duckdb$expr_reference("c")))
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = 1:3, c = 1)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(n = n(), n = n() + 1L, .by = g) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(duckdb$expr_reference("g")),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_function("n", list()),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1L, experimental = experimental)
            } else {
              duckdb$expr_constant(1L)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("g"), duckdb$expr_reference("n")))
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(g = 1:3, n = 2:4)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational summarise(n = n(), n = n() + 1L) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_function("n", list()),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1L, experimental = experimental)
            } else {
              duckdb$expr_constant(1L)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_distinct(rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("n")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(n = 7L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# symdiff order-preserving -------------------------------------------------------------

test_that("relational symdiff() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(
    DBI::dbExecute(con, 'CREATE MACRO "___eq_na_matches_na"(x, y) AS (x IS NOT DISTINCT FROM y)')
  )
  df1 <- data.frame(a = 1:4, b = 2)

  "anti_join"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "anti_join"
  rel2 <- duckdb$rel_set_alias(rel1, "lhs")
  df2 <- data.frame(a = 2:5, b = 2)

  "anti_join"
  rel3 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "anti_join"
  rel4 <- duckdb$rel_set_alias(rel3, "rhs")
  "anti_join"
  rel5 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      }
    )
  )
  "anti_join"
  rel6 <- duckdb$rel_join(
    rel5,
    rel4,
    list(
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("a", rel5), duckdb$expr_reference("a", rel4))),
      duckdb$expr_function("___eq_na_matches_na", list(duckdb$expr_reference("b", rel5), duckdb$expr_reference("b", rel4)))
    ),
    "anti"
  )
  "anti_join"
  rel7 <- duckdb$rel_order(rel6, list(duckdb$expr_reference("___row_number_x", rel5)))
  "anti_join"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  df3 <- data.frame(a = 1L, b = 2)

  "union_all"
  rel9 <- duckdb$rel_from_df(con, df3, experimental = experimental)
  df4 <- data.frame(a = 5L, b = 2)

  "union_all"
  rel10 <- duckdb$rel_from_df(con, df4, experimental = experimental)
  "union_all"
  rel11 <- duckdb$rel_project(
    rel9,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel12 <- duckdb$rel_project(
    rel10,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel13 <- duckdb$rel_union_all(rel11, rel12)
  "union_all"
  rel14 <- duckdb$rel_order(
    rel13,
    list(duckdb$expr_reference("___row_number_x"), duckdb$expr_reference("___row_number_y"))
  )
  "union_all"
  rel15 <- duckdb$rel_project(
    rel14,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel16 <- duckdb$rel_project(
    rel15,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel17 <- duckdb$rel_project(
    rel16,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- duckdb$expr_reference("a")
              duckdb$expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- duckdb$expr_reference("b")
              duckdb$expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel18 <- duckdb$rel_filter(
    rel17,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel19 <- duckdb$rel_order(rel18, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel20 <- duckdb$rel_project(
    rel19,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel20
  out <- duckdb$rel_to_altrep(rel20)
  expect_identical(
    out,
    data.frame(a = c(1L, 5L), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# symdiff order-enforcing --------------------------------------------------------------

test_that("relational symdiff() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = 2)

  "symdiff"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = 2)

  "symdiff"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "symdiff"
  rel3 <- duckdb$rel_set_symdiff(rel1, rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = c(1L, 5L), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# tally order-preserving ---------------------------------------------------------------

test_that("relational tally() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_distinct(rel2)
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(n = 6L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# tally order-enforcing ----------------------------------------------------------------

test_that("relational tally() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  invisible(DBI::dbExecute(con, 'CREATE MACRO "n"() AS CAST(COUNT(*) AS int32)'))
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "summarise"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "summarise"
  rel2 <- duckdb$rel_aggregate(
    rel1,
    groups = list(),
    aggregates = list(
      {
        tmp_expr <- duckdb$expr_function("n", list())
        duckdb$expr_set_alias(tmp_expr, "n")
        tmp_expr
      }
    )
  )
  "summarise"
  rel3 <- duckdb$rel_distinct(rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("n")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(n = 6L)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# transmute order-preserving -----------------------------------------------------------

test_that("relational transmute(c = a + 1) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "transmute"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "transmute"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      c = {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(c = seq(2, 7, by = 1))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational transmute(row = a) order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "transmute"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "transmute"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      row = {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "row")
        tmp_expr
      }
    )
  )
  rel2
  out <- duckdb$rel_to_altrep(rel2)
  expect_identical(
    out,
    data.frame(row = seq(1, 6, by = 1))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# transmute order-enforcing ------------------------------------------------------------

test_that("relational transmute(c = a + 1) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "transmute"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "transmute"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      c = {
        tmp_expr <- duckdb$expr_function(
          "+",
          list(
            duckdb$expr_reference("a"),
            if ("experimental" %in% names(formals(duckdb$expr_constant))) {
              duckdb$expr_constant(1, experimental = experimental)
            } else {
              duckdb$expr_constant(1)
            }
          )
        )
        duckdb$expr_set_alias(tmp_expr, "c")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("c")))
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(c = seq(2, 7, by = 1))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

test_that("relational transmute(row = a) order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = seq(1, 6, by = 1), b = 2, g = c(1L, 2L, 2L, 3L, 3L, 3L))

  "transmute"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  "transmute"
  rel2 <- duckdb$rel_project(
    rel1,
    list(
      row = {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "row")
        tmp_expr
      }
    )
  )
  "arrange"
  rel3 <- duckdb$rel_order(rel2, list(duckdb$expr_reference("row")))
  rel3
  out <- duckdb$rel_to_altrep(rel3)
  expect_identical(
    out,
    data.frame(row = seq(1, 6, by = 1))
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# union order-preserving ---------------------------------------------------------------

test_that("relational union() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = 2)

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = 2)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- duckdb$rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("___row_number_x"), duckdb$expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  "distinct"
  rel8 <- duckdb$rel_project(
    rel7,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number")
        tmp_expr
      }
    )
  )
  "distinct"
  rel9 <- duckdb$rel_project(
    rel8,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      duckdb$expr_reference("___row_number"),
      {
        tmp_expr <- duckdb$expr_window(
          duckdb$expr_function("row_number", list()),
          list(
            a = {
              tmp_expr <- duckdb$expr_reference("a")
              duckdb$expr_set_alias(tmp_expr, "a")
              tmp_expr
            },
            b = {
              tmp_expr <- duckdb$expr_reference("b")
              duckdb$expr_set_alias(tmp_expr, "b")
              tmp_expr
            }
          ),
          list(duckdb$expr_reference("___row_number")),
          offset_expr = NULL,
          default_expr = NULL
        )
        duckdb$expr_set_alias(tmp_expr, "___row_number_by")
        tmp_expr
      }
    )
  )
  "distinct"
  rel10 <- duckdb$rel_filter(
    rel9,
    list(
      duckdb$expr_comparison(
        "==",
        list(
          duckdb$expr_reference("___row_number_by"),
          if ("experimental" %in% names(formals(duckdb$expr_constant))) {
            duckdb$expr_constant(1L, experimental = experimental)
          } else {
            duckdb$expr_constant(1L)
          }
        )
      )
    )
  )
  "distinct"
  rel11 <- duckdb$rel_order(rel10, list(duckdb$expr_reference("___row_number")))
  "distinct"
  rel12 <- duckdb$rel_project(
    rel11,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel12
  out <- duckdb$rel_to_altrep(rel12)
  expect_identical(
    out,
    data.frame(a = 1:5, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# union order-enforcing ----------------------------------------------------------------

test_that("relational union() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = 2)

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = 2)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_union_all(rel1, rel2)
  "distinct"
  rel4 <- duckdb$rel_distinct(rel3)
  "arrange"
  rel5 <- duckdb$rel_order(rel4, list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
  rel5
  out <- duckdb$rel_to_altrep(rel5)
  expect_identical(
    out,
    data.frame(a = 1:5, b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# union_all order-preserving -----------------------------------------------------------

test_that("relational union_all() order-preserving", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = 2)

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = 2)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_project(
    rel1,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel4 <- duckdb$rel_project(
    rel2,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      },
      {
        tmp_expr <- if ("experimental" %in% names(formals(duckdb$expr_constant))) {
          duckdb$expr_constant(NA_integer_, experimental = experimental)
        } else {
          duckdb$expr_constant(NA_integer_)
        }
        duckdb$expr_set_alias(tmp_expr, "___row_number_x")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_window(duckdb$expr_function("row_number", list()), list(), list(), offset_expr = NULL, default_expr = NULL)
        duckdb$expr_set_alias(tmp_expr, "___row_number_y")
        tmp_expr
      }
    )
  )
  "union_all"
  rel5 <- duckdb$rel_union_all(rel3, rel4)
  "union_all"
  rel6 <- duckdb$rel_order(
    rel5,
    list(duckdb$expr_reference("___row_number_x"), duckdb$expr_reference("___row_number_y"))
  )
  "union_all"
  rel7 <- duckdb$rel_project(
    rel6,
    list(
      {
        tmp_expr <- duckdb$expr_reference("a")
        duckdb$expr_set_alias(tmp_expr, "a")
        tmp_expr
      },
      {
        tmp_expr <- duckdb$expr_reference("b")
        duckdb$expr_set_alias(tmp_expr, "b")
        tmp_expr
      }
    )
  )
  rel7
  out <- duckdb$rel_to_altrep(rel7)
  expect_identical(
    out,
    data.frame(a = c(1L, 2L, 3L, 4L, 2L, 3L, 4L, 5L), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})

# union_all order-enforcing ------------------------------------------------------------

test_that("relational union_all() order-enforcing", {
  # Autogenerated
  duckdb <- asNamespace("duckdb")
  drv <- duckdb::duckdb()
  con <- DBI::dbConnect(drv)
  experimental <- FALSE
  df1 <- data.frame(a = 1:4, b = 2)

  "union_all"
  rel1 <- duckdb$rel_from_df(con, df1, experimental = experimental)
  df2 <- data.frame(a = 2:5, b = 2)

  "union_all"
  rel2 <- duckdb$rel_from_df(con, df2, experimental = experimental)
  "union_all"
  rel3 <- duckdb$rel_union_all(rel1, rel2)
  "arrange"
  rel4 <- duckdb$rel_order(rel3, list(duckdb$expr_reference("a"), duckdb$expr_reference("b")))
  rel4
  out <- duckdb$rel_to_altrep(rel4)
  expect_identical(
    out,
    data.frame(a = c(1L, 2L, 2L, 3L, 3L, 4L, 4L, 5L), b = 2)
  )
  DBI::dbDisconnect(con, shutdown = TRUE)
})
