% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_obj.R
\name{get_risk_obj}
\alias{get_risk_obj}
\title{Get the risk set at each bin over an equal distance grid}
\usage{
get_risk_obj(Y, by, max_T, id, is_for_discrete_model = T)
}
\arguments{
\item{Y}{Vector of outcome variable}

\item{by}{Length of each bin}

\item{max_T}{Last observed time}

\item{id}{Vector with ids where entries match with outcomes \code{Y}}

\item{is_for_discrete_model}{\code{TRUE}/\code{FALSE} for whether the model outcome is discrete. For example, a logit model is discrete whereas what is coined an exponential model in this package is a dynamic model}
}
\value{
A list with the following elements:
\describe{
\item{\code{risk_sets}}{List of lists with one for each bin. Each of the sub lists have indices that corresponds to the entries of \code{Y} that are at risk in the bin }
\item{\code{min_start}}{ Start time of the first bin }
\item{\code{I_len}}{ Length of each bin }
\item{\code{d}}{ Number of bins }
\item{\code{is_event_in}}{ Indices for which bin an observation \code{Y} is an event. \code{-1} if the individual does not die in any of the bins }
\item{\code{is_for_discrete_model}}{ Value of \code{is_for_discrete_model} argument}
}
}
\description{
Get the risk set at each bin over an equal distance grid
}

