% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrPlot.R
\name{plotFormula}
\alias{plotFormula}
\title{Plot the formula from a model}
\usage{
plotFormula(dynrModel, ParameterAs, printDyn = TRUE, printMeas = TRUE,
  printRS = FALSE, textsize = 4)
}
\arguments{
\item{dynrModel}{The model object to plot.}

\item{ParameterAs}{The parameter values or names to plot. The underscores in parameter names are saved for 
use of subscripts.  Greek letters can be specified as corresponding LaTeX symbols without backslashes (e.g., "lambda") 
and printed as greek letters.}

\item{printDyn}{A logical value indicating whether or not to plot the formulas for the dynamic model.}

\item{printMeas}{A logical value indicating whether or not to plot the formulas for the measurement model}

\item{printRS}{logical. Whether or not to print the regime-switching model. The default is FALSE.}

\item{textsize}{The text size use in the plot.}
}
\description{
Plot the formula from a model
}
\details{
This function typesets a set of formulas that represent the model.  Typical inputs to the \code{ParameterAs} argument are (1) the starting values for a model, (2) the final estimated values for a model, and (3) the parameter names.  These are accessible with (1) \code{model$xstart}, (2) \code{coef(cook)}, and (3) \code{model$param.names} or \code{names(coef(cook))}, respectively.
}

