% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.loadings}
\alias{prep.loadings}
\title{Recipe function to quickly create factor loadings}
\usage{
prep.loadings(map, params, idvar, exo.names = character(0))
}
\arguments{
\item{map}{list giving how the latent variables map onto the observed variables}

\item{params}{parameter numbers}

\item{idvar}{Names of the variables used to identify the factors}

\item{exo.names}{names of the exogenous covariates}
}
\description{
Recipe function to quickly create factor loadings
}
\details{
The default pattern for 'idvar' is to fix the first factor loading
for each factor to one.  The variable names listed in 'idvar' have
their factor loadings fixed to one.  However, if the names of the
latent variables are used for 'idvar', then all the factor loadings
will be freely estimated and you should fix the factor variances
in the noise part of the model (e.g. \code{\link{prep.noise}}).

This function does not have the full set of features possible in
the dynr package. In particular, it does not have regime-swtiching
factor loadings, any intercepts, or any covariates.  For complete
functionality use \code{\link{prep.measurement}}.
}
\examples{
#Single factor model with one latent variable fixing first loading
prep.loadings(list(eta1=paste0('y', 1:4)), paste0("lambda_",2:4))

#Single factor model with one latent variable fixing the fourth loading
prep.loadings(list(eta1=paste0('y', 1:4)), paste0("lambda_",1:3), idvar='y4')

#Single factor model with one latent variable freeing all loadings
prep.loadings(list(eta1=paste0('y', 1:4)), paste0("lambda_", 1:4), idvar='eta1')

# Two factor model with simple structure
prep.loadings(list(eta1=paste0('y', 1:4), eta2=paste0('y', 5:7)),
paste0("lambda_", c(2:4, 6:7)))

#Two factor model with repeated use of a free parameter
prep.loadings(list(eta1=paste0('y', 1:4), eta2=paste0('y', 5:8)),
paste0("lambda_", c(2:4, 6:7, 4)))

#Two factor model with a cross loading
prep.loadings(list(eta1=paste0('y', 1:4), eta2=c('y5', 'y2', 'y6')),
paste0("lambda_", c("21", "31", "41", "22", "62")))
}

