% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.tfun}
\alias{prep.tfun}
\title{Create a dynrTrans object to handle the transformations and inverse
transformations of model paramters}
\usage{
prep.tfun(formula.trans, formula.inv, transCcode = TRUE)
}
\arguments{
\item{formula.trans}{a list of formulae for transforming freed parameters
other than variance-covariance parameters during the optimization process.
These transformation functions may be helpful for transforming parameters
that would normally appear on a constrained scale to an unconstrained
scale (e.g., parameters that can only take on positive values can be
subjected to exponential transformation to ensure positivity.)}

\item{formula.inv}{a list of formulae that inverse the transformation
on the free parameters and will be used to calculate the starting values
of the parameters.}

\item{transCcode}{a logical value indicating whether the functions in
formula.trans need to be transformed to functions in C. The default
for transCcode is TRUE, which means that the formulae will be translated
to C functions and utilized during the optimization process.
If transCcode = FALSE, the transformations are only performed at the end
of the optimization process for standard error calculations but not
during the optimization process.}
}
\description{
Create a dynrTrans object to handle the transformations and inverse
transformations of model paramters
}

